/**
 * Network Transparency ("Code Snippets")
 **/


#include <ktempfile.h>

void MainWindow::slotSaveAs()
{
    url=KFileDialog::getSaveUrl(0,
    "*.txt|Text Files (*.txt)\n*.cpp|C++ Source Files (*.cpp)",this)
    file=url.path();

    if (!file.isLocalPath())
    {
         KTempFile temp;
         file=temp.name(); // Get somewhere local to write to

         slotSave(); // write to that
         temp.unlink();
         return;
    }
    // As of here, the url will always be local, which means that file contains
    // the local path of the file to save! So lets just save it!
    slotSave();
}

void MainWindow::slotSave()
{
    // Looks like there isn't a selected file yet!
    if (url.isEmpty() || file.isEmpty())
         slotSaveAs(), return;

    // Lets save the file.
    QFile f(file);

    // IO_Truncate purges the file so we start with a clean slate
    if (!f.open(IO_WriteOnly | IO_Truncate))
         KNotifyClient::event("cannotopenfile"), return;

    QTextStream t( &f );
    // QDataStream may be more appropriate for some purposes, check the QT documentation
    // for all your file-storing needs.
    t << "The filename that was stored is " << file << '\n';

    f.close();

    // TODO: Set a flag to true, telling you that this file is currently saved.
}

void MainWindow::slotOpen()
{
    if ( /* TODO: test if the currently opened file needs to be saved */ )
    { // User already has a file open! What does this person want to do
      // with this file?
         int result=KMessageBox::questionYesNo(this,
              i18n("You already have a file open! Would you like to save the currently "
                   "opened file and open another?"), i18n("Continue?"));

         if (result==KMessageBox::Yes)
              slotSave();
         else
              return;
    }

    url=KFileDialog::getOpenURL(0,
         "*.txt|Text Files (*.txt)\n*.cpp|C++ Source Files (*.cpp)",this);

    if (!KIO::NetAccess::download(url, file))
        KNotifyClient::event("cannotopenfile"), return;

    QFile f(file);
    if (!f.open(IO_ReadOnly))
         KNotifyClient::event("cannotopenfile"), return;

    QTextStream t( &f );
    QString dataFromFile;
    t>>dataFromFile;
    // TODO: Do something with the data!

    f.close();
}
