#include <qapplication.h>
#include <qwidget.h>
#include <iostream.h>


// A Window class definition
class MyWindow : public QWidget
{
public:
  // Constructor, Parent is always 0
  MyWindow() : QWidget() { }
protected:
  // This function will be called when the user press a mouse button
  void mousePressEvent(QMouseEvent *);
};


void MyWindow::mousePressEvent(QMouseEvent *)
{
  // Just print "Mouse Press"
  cout << "Mouse Press" << endl;
}


int main(int argc, char **argv){
  QApplication app(argc, argv);

  // Create a MyWindow object
  MyWindow window;

  // Move and resize the MyWindow object 
  // left=100, top=50, width=400, height=300
  window.setGeometry(100,50,400,300);

  // Main window = MyWindow object
  app.setMainWidget(&window);

  window.setCaption("QWidget example");

  // Show the window
  window.show();

  // Go to the main loop
  return app.exec();
}