#include "Widget.h"
#include <qlined.h>

class LineEdit : public Widget
{
  Q_OBJECT;
public:
  LineEdit(Widget *parent=0, const char *name = 0);
  ~LineEdit();

  const char *text();
  int maxLength();
  void setMaxLength(int maxlength);
  void setFrame(int f);
  bool frame() const;

  enum EchoMode { Normal, NoEcho, Password };
  void setEchoMode(EchoMode newechomode);
  LineEdit::EchoMode echoMode() const;

  // These act as slots
  void setText(const char *text);
  void selectAll();
  void deselect();

  // These act as signals
private slots:
  void textChanged(const char* newtext);
  void returnPressed();

private:
  QLineEdit *lineedit;
};

