#include <qlabel.h>
#include "Application.h"
#include "Label.h"

Label::Label(Widget *parent, const char *name)
  : Frame("") // use abstract frame
{
  if(parent)
    {
      label = new QLabel(parent->widget,name);
    }
  else
    {
      label = new QLabel(NULL,name);
    }

  Frame::setWidget((QFrame*)label);
}

Label::Label(const char *text, Widget *parent=0, const char *name=0)
  : Frame("")
{
  if(parent)
    {
      label = new QLabel(text,parent->widget,name);
    }
  else
    {
      label = new QLabel(text,NULL,name);
    }

  Frame::setWidget((QFrame*)label);
}

Label::Label(Widget *buddy, const char *text, Widget *parent, 
	     const char *name)
{
  if(parent)
    {
      label = new QLabel(buddy->widget,text,parent->widget,name);
    }
  else
    {
      label = new QLabel(buddy->widget,text,NULL,name);
    }

  Frame::setWidget((QFrame*)label);
}

Label::~Label()
{
}

const char * Label::text()
{
  return label->text();
}

QPixmap *Label::pixmap() const
{
  return label->pixmap();
}

int Label::alignment()
{
  return label->alignment();
}

void Label::setAlignment(int a)
{
  label->setAlignment(a);
}

int Label::margin()
{
  return label->margin();
}

void Label::setMargin(int m)
{
  label->setMargin(m);
}

bool Label::autoResize()
{
  return label->autoResize();
}

void Label::setAutoResize(bool ar)
{
  label->setAutoResize(ar);
}

QSize Label::sizeHint() const
{
  return label->sizeHint();
}

void Label::setBuddy(Widget *buddy)
{
  if(buddy)
    label->setBuddy(buddy->widget);
  else
    label->setBuddy(NULL);
}

Widget *Label::buddy() const
{
  QWidget *got = label->buddy();
  Widget *w;
  for(w=Widgets->first(); w!=0; w=Widgets->next())
    {
      if(w->widget == got)
	return w;
    }
  return NULL;
}

void Label::setText(const char *text)
{
  label->setText(text);
}

void Label::setPixmap(const QPixmap& pixmap)
{
  label->setPixmap(pixmap);
}

void Label::setNum(int num)
{
  label->setNum(num);
}

void Label::setNum(double num)
{
  label->setNum(num);
}



