%{
#include <Python.h>
#include <qstrlist.h>
#include <qstring.h>
%}


// enable Python functions to work as callback functions

%typemap(python,in) PyObject *slot {
  if(!PyCallable_Check($source))
  {
    PyErr_SetString(PyExc_TypeError, "Need a callable object!");
    return NULL;
  }
  $target = $source;
}


// enable lists to be passed as char **

%typemap(python,in) char ** {

  // check if it is a list
  if (PyList_Check($source)) {
    int size = PyList_Size($source);
    int i = 0;
    $target = (char **) malloc((size+1)*sizeof(char *));
    for (i=0; i < size; i++) {
      PyObject *Obj = PyList_GetItem($source,i);
      if (PyString_Check(Obj)) {
 	$target[i]=PyString_AsString(PyList_GetItem($source,i));
      } else {
	PyErr_SetString(PyExc_TypeError,"List must contain strings");
     	free($target);
	return 0;
      }
    }	    
    $target[i] = 0;	
  } else {
    PyErr_SetString(PyExc_TypeError,"not a list");
    return 0;
  }	
}

%typemap(python,freearg) char ** {
  free((char *) $source);
}


// enable char ** to be returned as a python list

%typemap(python,out) char ** {
  int len,i;
  len = 0;
  while ($source[len]) len++;
  $target = PyList_New(len);
  for (i=0; i<len; i++) {
    if ($source[i])
      PyList_SetItem($target,i,PyString_FromString($source[i]));
    else
      PyList_SetItem($target,i,PyString_FromString(""));   
  }
}

%typemap(python,freearg) char ** {
  free((char *) $source);
}


// enable lists of strings to be passed as QStrList *

%typemap(python,in) QStrList * {

  // check if it is a list
  if (PyList_Check($source)) {
    int size = PyList_Size($source);
    int i = 0;
    $target = new QStrList();
    for (i=0; i < size; i++) {
      PyObject *Obj = PyList_GetItem($source,i);
      if (PyString_Check(Obj)) {
 	$target->append(PyString_AsString(PyList_GetItem($source,i)));
      } else {
	PyErr_SetString(PyExc_TypeError,"List must contain strings");
     	free($target);
	return 0;
      }
    }	    
  } else {
    PyErr_SetString(PyExc_TypeError,"not a list");
    return 0;
  }	
  
}

%typemap(python,freearg) QStrList * {
  delete $source;
}


// enable QStrList * to be returned as a python list

%typemap(python,out) QStrList * {
  int i, len = 0;

  if ($source)
    len = $source->count();

  $target = PyList_New(len);
  for (i=0; i<len; i++) {
    if ($source->at(i))
      PyList_SetItem($target,i,PyString_FromString($source->at(i)));
    else
      PyList_SetItem($target,i,PyString_FromString(""));
  }  
}


// enable QObjectList * to be returned as a python list

%typemap(python,out) QObjectList * {
  int i, len = 0;
  char ptr[30];

  if ($source)
    len = $source->count();

  $target = PyList_New(len);
  for (i=0; i<len; i++) {
    SWIG_MakePtr(ptr, $source->at(i), "_Object_p_");
    if (ptr)
      PyList_SetItem($target,i,PyString_FromString(ptr));
    else
      PyList_SetItem($target,i,PyString_FromString(""));
  }  
}


// enable QRect to be returned as a 4-tupel (x,y,w,h)

%typemap(python,out) QRect, QRect & {
  $target = PyTuple_New(4);
  PyTuple_SetItem($target, 0, PyInt_FromLong($source->x()));
  PyTuple_SetItem($target, 1, PyInt_FromLong($source->y()));
  PyTuple_SetItem($target, 2, PyInt_FromLong($source->width()));
  PyTuple_SetItem($target, 3, PyInt_FromLong($source->height()));
}


// enable QRect to be passed as a 4-tupel (x,y,w,h)

%typemap(python,in) QRect, QRect & (QRect r, int x, int y, int w, int h) {

  if (PyTuple_Check($source)) {
    if (!PyArg_ParseTuple($source, "iiii", &x, &y, &w, &h)) {
      PyErr_SetString(PyExc_TypeError, "expected tuple of 4 integers (x,y,w,h)");
      return 0;	
    }	
    r.setX(x); r.setY(y); r.setWidth(w); r.setHeight(h);
    $target = &r;
  } else {
    PyErr_SetString(PyExc_TypeError,"not a tuple (x,y,w,h)");
    return 0;
  }	
}


// enable QPoint to be passed as a 2-tupel (x,y)

%typemap(python,in) QPoint, QPoint & (QPoint pt, int x, int y) {

  if (PyTuple_Check($source)) {
    if (!PyArg_ParseTuple($source, "ii", &x, &y)) {
      PyErr_SetString(PyExc_TypeError, "expected tuple of 2 integers (x,y)");
      return 0;	
    }	
    pt.setX(x); pt.setY(y);
    $target = &pt;
  } else {
    PyErr_SetString(PyExc_TypeError,"not a tuple (x,y)");
    return 0;
  }	
}


// enable QSize to be passed as a 2-tupel (x,y)

%typemap(python,in) QSize, QSize & (QSize sz, int x, int y) {

  if (PyTuple_Check($source)) {
    if (!PyArg_ParseTuple($source, "ii", &x, &y)) {
      PyErr_SetString(PyExc_TypeError, "expected tuple of 2 integers (x,y)");
      return 0;	
    }	
    sz.setWidth(x); sz.setHeight(y);
    $target = &sz;
  } else {
    PyErr_SetString(PyExc_TypeError,"not a tuple (x,y)");
    return 0;
  }	
}

// enable QPoint to be returned as a 2-tupel (x,y)

%typemap(python,out) QPoint, QPoint & {
  $target = PyTuple_New(2);
  PyTuple_SetItem($target, 0, PyInt_FromLong($source->x()));
  PyTuple_SetItem($target, 1, PyInt_FromLong($source->y()));
}


// enable QSize to be returned as a 2-tupel (w,h)

%typemap(python,out) QSize, QSize & {
  $target = PyTuple_New(2);
  PyTuple_SetItem($target, 0, PyInt_FromLong($source->width()));
  PyTuple_SetItem($target, 1, PyInt_FromLong($source->height()));
}


// enable QString to be returned as python string

%typemap(python,out) QString, QString & {
  if (!$source->isNull())
    $target = PyString_FromString($source->data());
  else
    $target = PyString_FromString("");
}


// enable string to be passed as QString 

%typemap(python,in) QString, QString & (QString x) {
  if (PyString_Check($source)) {
    x = PyString_AsString($source);
    $target = &x;
  } else {
    PyErr_SetString(PyExc_TypeError,"not a string");
    return 0;
  }	
  
}