#ifndef _SCROLLBAR_H_
#define _SCROLLBAR_H_

#include <Python.h>
#include <qscrbar.h>
#include "Baseobject.h"


class ScrollBar : public QScrollBar, BaseObject
{
  Q_OBJECT

  public:

    ScrollBar(int min, int max, int line, int page, int value, 
            Orientation ot, QWidget *parent=0, const char *name=0) :
    QScrollBar(min,max,line,page,value,ot,parent,name), BaseObject()
  {
    connect(this, SIGNAL(sliderPressed()), this, SLOT(sigSliderPressed()));
    connect(this, SIGNAL(sliderMoved(int)), this, SLOT(sigSliderMoved(int)));
    connect(this, SIGNAL(sliderReleased()), this, SLOT(sigSliderReleased()));
    connect(this, SIGNAL(valueChanged(int)), this, SLOT(sigValueChanged(int)));    
    connect(this, SIGNAL(nextLine()), this, SLOT(sigNextLine()));
    connect(this, SIGNAL(prevLine()), this, SLOT(sigPrevLine()));
    connect(this, SIGNAL(nextPage()), this, SLOT(sigNextPage()));
    connect(this, SIGNAL(prevPage()), this, SLOT(sigPrevPage()));
  }
  ~ScrollBar() {};

  protected slots:

    void sigSliderPressed() {
      _emit("pressed", 0);
    };
    
    void sigSliderReleased() {
      _emit("released", 0);
    };
    
    void sigSliderMoved(int value) {
      PyObject *arg = Py_BuildValue("(i)",value);
      _emit("sliderMoved", arg);
      Py_DECREF(arg);
    };

    void sigValueChanged(int value) {
      PyObject *arg = Py_BuildValue("(i)",value);
      _emit("valueChanged", arg);
      Py_DECREF(arg);
    };

    void sigNextLine() {
      _emit("nextLine", 0);
    };
    
    void sigPrevLine() {
      _emit("prevLine", 0);
    };
    
    void sigNextPage() {
      _emit("nextPage", 0);
    };
    
    void sigPrevPage() {
      _emit("prevPage", 0);
    };
    
};

#endif


