%module Rangecontrol


%include Types.i
%include Object.i


class QRangeControl : public Object
{
public:
    QRangeControl( int minValue, int maxValue,
		   int lineStep, int pageStep, int value );
    ~QRangeControl();

    int		value()		const;
    void	setValue( int );
    void	addPage();
    void	subtractPage();
    void	addLine();
    void	subtractLine();

    int		minValue()	const;
    int		maxValue()	const;
    void	setRange( int minValue, int maxValue );

    int		lineStep()	const;
    int		pageStep()	const;
    void	setSteps( int line, int page );
};
