%module Multilineedit


%{
#include "Object.h"
#include "Button.h"
#include "Multilineedit.h"
%}


%include Types.i
%include Constants.i
%import Object.i
%import Widget.i
%import Frame.i
%import Cursor.i


class MultiLineEdit : public QFrame
{
public:
    MultiLineEdit(QWidget *parent=0, const char *name=0 );
   ~MultiLineEdit();

    const char *textLine( int line ) const;
    QString text() const;

    int numLines() const;

    bool	isReadOnly() const;
    bool	isOverwriteMode() const;

    virtual void insertLine( const char *s, int line = -1 );
    virtual void insertAt( const char *s, int line, int col );
    virtual void removeLine( int line );

    void	setCursorPosition( int line, int col, bool mark = FALSE );

    bool	atBeginning() const;
    bool	atEnd() const;

    bool	autoUpdate()	const;
    void	setAutoUpdate( bool );

    void       clear();
    void       setText( const char * );
    void       append( const char * );
    void       deselect();
    void       selectAll();
    void       setReadOnly( bool );
    void       setOverwriteMode( bool );
    void       paste();
    void       copyText();
    void       cut();

/*
signals:
    void	textChanged();
    void	returnPressed();
*/
 
};
