%module Gridlayout


%{
#include <qlayout.h>
%}


%import Layout.i


class QGridLayout : public QLayout
{
public:
    QGridLayout( int nRows, int nCols, int autoBorder = -1,
		 const char *name=0 );
%name(QGridLayoutParent)    QGridLayout( QWidget *parent, int nRows, int nCols, int border=0,
		 int autoBorder = -1, const char *name=0 );
    ~QGridLayout();

    void addWidget( QWidget *, int row, int col, int align = 0 );
    void addMultiCellWidget( QWidget *, int fromRow, int toRow, 
			       int fromCol, int toCol, int align = 0 );
    void addLayout( QLayout *layout, int row, int col);

    void setRowStretch( int row, int stretch );
    void setColStretch( int col, int stretch );
    void addRowSpacing( int row, int minsize );
    void addColSpacing( int col, int minsize );
};
