%module Boxlayout


%{
#include <qlayout.h>
%}


%import Layout.i


class QBoxLayout : public QLayout
{
public:
    enum Direction { LeftToRight, RightToLeft, TopToBottom, BottomToTop, 
		     Down = TopToBottom, Up = BottomToTop };

    QBoxLayout(	Direction, int autoBorder = -1,
		const char *name=0 );

%name(QBoxLayoutParent)    QBoxLayout( QWidget *parent, Direction, int border=0,
		int autoBorder = -1, const char *name=0 );

    ~QBoxLayout();

    void addSpacing( int size );
    void addStretch( int stretch = 0 );
    void addWidget( QWidget *, int stretch = 0, int alignment = AlignCenter );
    void addLayout( QLayout *layout, int stretch = 0 );
    Direction direction() const { return (Direction)dir; }

    void addStrut( int dummy );
};
