%module KToolbar


%{
#include "KToolbar.h"
%}


%include Types.i
%import KCombobox.i


enum itemType {
    ITEM_LINED = 0,
    ITEM_BUTTON = 1,
    ITEM_COMBO = 2,
    ITEM_FRAME = 3,
    ITEM_TOGGLE = 4,
    ITEM_ANYWIDGET=5
};


class _ToolBarButton : public Button
 {
 public:
   _ToolBarButton(QWidget *parent=0L, const char *name=0L);
%name(_ToolBarButtonPixmap)   _ToolBarButton(const QPixmap& pixmap, int id, QWidget *parent,
                  const char *name=0L, int item_size = 26, const char *txt=0);
   ~_ToolBarButton() {};
   void setEnabled(bool enable);
   void makeDisabledPixmap();
   
   void setPixmap( const QPixmap & );
   void on(bool flag);
   void toggle();
   void beToggle(bool);
   bool ImASeparator () {return sep;};
   void youreSeparator () {sep = true;};

/*
 signals:
     void clicked(int);
     void pressed(int);
     void released(int);
     void toggled(int);
*/
};


class _ToolBar : public QFrame
{
public:
  enum BarStatus{Toggle, Show, Hide};
  enum BarPosition{Top, Left, Bottom, Right, Floating};

  _ToolBar(QWidget *parent=0L, const char *name=0L, int _item_size = 26);
  virtual ~_ToolBar();

  int insertButton(const QPixmap& pixmap, int ID, bool enabled = true,
                   const char *ToolTipText = 0L, int index=-1 );

  int addButton(const QPixmap& pixmap, int ID, 
			  const char *signal, PyObject *slot, 
			  bool enabled=true, const char *ToolTopText=0,int index=-1);

  int addLined (const char *text, int ID,
                   const char *signal, PyObject *slot,
                   bool enabled = true,
                   const char *toolTipText = 0L, int size = 70, int index =-1);

  int addComboList (QStrList *list, int id, bool writable,
                   const char *signal, PyObject *slot,
                   bool enabled=true,
                   const char *tooltiptext=0L,
                   int size=70, int index=-1,
                   _ComboBox::Policy policy = _ComboBox::AtBottom);

  int addComboText(const char *text, int id, bool writable,
                   const char *signal, PyObject *slot,
                   bool enabled=true,
                   const char *tooltiptext=0L,
                   int size=70, int index=-1,
                   _ComboBox::Policy policy = _ComboBox::AtBottom);

  int insertSeparator(int index=-1);

  int insertWidget(int id, int width, QWidget *_widget, int index=-1);

  void addConnection (int id, const char *signal, PyObject *slot);

  void setItemEnabled( int id, bool enabled );
  void setButtonPixmap( int id, const QPixmap& _pixmap );
  void setToggle (int id, bool flag = true);
  void toggleButton (int id);
  void setButton (int id, bool flag);
  bool isButtonOn (int id);
  void setLinedText (int id, const char *text);
  const char *getLinedText (int id);
  void insertComboList (int id, QStrList *list, int index);
  void removeComboItem (int id, int index);
  void setCurrentComboItem (int id, int index);
  void changeComboItem  (int id, const char *text, int index=-1);
  void clearCombo (int id);
  const char *getComboItem (int id, int index=-1);
  _ComboBox * getCombo(int id);
  KLined * getLined (int id);
  _ToolBarButton * getButton (int id);
  void alignItemRight (int id, bool right = true);
  QFrame * getFrame (int id);
  QWidget *getWidget (int id);
  void setItemAutoSized (int id, bool yes = true);
  void removeItem (int id);
  void hideItem (int id);
  void showItem (int id);
  void setFullWidth(bool flag = true);    // Top and Bottom pos only
  void enableMoving(bool flag = true);
  void setBarPos (BarPosition bpos);
  BarPosition barPos() {return position;};
  bool enable(BarStatus stat);
  void setMaxHeight (int h);  // Set max height for vertical toolbars
  void setMaxWidth (int dw);
  void setTitle (const char *_title) {title = _title;};
  void enableFloating (bool arrrrrrgh);
  void updateRects(bool resize = false);

/*
signals:
    void clicked(int id);
    void pressed(int);
    void released(int);
    void toggled(int);
    void moved( BarPosition );
*/
};
