#ifndef _KICONLOADERDIALOG_H_
#define _KICONLOADERDIALOG_H_

#include <Python.h>
#include <kiconloaderdialog.h>
#include "Baseobject.h"


class _IconLoaderButton : public KIconLoaderButton, public BaseObject
{
  Q_OBJECT
public:
  _IconLoaderButton(QWidget *widget) : KIconLoaderButton(widget) {  
    connect(this, SIGNAL(iconChanged(const char*)), this, SLOT(sigIconChanged(const char*)));
  };
  _IconLoaderButton(KIconLoader *iconLoader, QWidget *widget) : KIconLoaderButton(iconLoader,widget) {
    connect(this, SIGNAL(iconChanged(const char*)), this, SLOT(sigIconChanged(const char*)));
  };
  
protected slots:

    void sigToggled(const char *icon) {
       PyObject *arg = Py_BuildValue("(s)",icon);
       _emit("iconChanged", arg);  
       Py_DECREF(arg);
    };
};


#endif