%module Rootprop

%{
#include "Baseobject.h"
#include <krootprop.h>
%}

%include Types.i
%include Constants.i

%import Baseobject.i
%import Font.i
%import Color.i


class KRootProp : public BaseObject
{
public:
   KRootProp();
  ~KRootProp();

  void setProp(const QString & rProp);

  QString readEntry( const QString& rKey, 
  	  	  	  	  	  const char* pDefault = 0 ) const ;
  int readNumEntry( const QString& rKey, int nDefault = 0 ) const;
  QFont readFontEntry( const QString& rKey, 
							  const QFont* pDefault = 0 ) const;
  QColor readColorEntry( const QString& rKey,
								const QColor* pDefault = 0 ) const;
  QString writeEntry( const QString& rKey, const QString& rValue );
%name(writeIntEntry)  QString writeEntry( const QString& rKey, int nValue );
%name(writeFontEntry)  QString writeEntry( const QString& rKey, const QFont& rFont );
%name(writeColorEntry)  QString writeEntry( const QString& rKey, const QColor& rColor );
  
  void sync();
};
