# Import the libraries

from qt.popupmenu import *
from qt.widget import *

from kde.application import *
from kde.edit import *
from kde.menubar import *
from kde.toplevelwidget import *
from kde.statusbar import *
from kde.toolbar import *
from kde.button import *


##
## function declarations
##

# auxiliary functions

def getIcon(name):
    return KApp().getIconLoader().loadIcon(name)


# menu functions

def newFile(index=0):
    editor.newFile()

def loadFile(index=0):
    editor.openFile(editor.OPEN_READWRITE)

def saveFile(index=0):
    editor.doSave()

def saveFileAs(index=0):
    editor.saveAs()

##
## The main program
##


# Create the application instance

app = KApplication("PythonKDE Editor")


# Setup the main window

topwidget = KTopLevelWidget()
editor = KEdit(app,topwidget)
topwidget.setView(editor)


# Create the menubar

mn = KMenuBar(topwidget)
file = PopupMenu()
file.insertItem("&New", newFile)
file.insertItem("&Load...", loadFile)
file.insertItem("&Save", saveFile)
file.insertItem("Save &As...", saveFileAs)
file.insertItem("&Insert file...", editor.insertFile)
file.insertSeparator()
file.insertItem("&Quit", app.quit)
mn.popupItemAt("&File",file)
edit = PopupMenu()
edit.insertItem("&Copy", editor.copyText)
edit.insertItem("&Insert", editor.paste)
edit.insertItem("C&ut", editor.cut)
edit.insertItem("Select &all", editor.selectAll)
edit.insertSeparator()
edit.insertItem("&Search...", editor.Search)
edit.insertItem("&Replace...", editor.Replace)
edit.insertItem("Repeat &last", editor.repeatSearch)
edit.insertSeparator()
edit.insertItem("&Goto line...", editor.doGotoLine)
mn.popupItemAt("&Edit", edit)
options = PopupMenu()
options.insertItem("&Font...", editor.selectFont)
mn.popupItemAt("&Options", options)
mn.insertSeparator()
mn.popupItemAt("&Help",app.getHelpMenu(0,"PythonKDE Editor 0.01"))
topwidget.setMenu(mn)


# Create the toolbar

toolbar = KToolBar(topwidget)
topwidget.addToolBar(toolbar)
toolbar.addButton(getIcon("filenew.xpm"),"clicked",newFile)
toolbar.addButton(getIcon("fileopen.xpm"),"clicked",loadFile)
toolbar.addButton(getIcon("filefloppy.xpm"),"clicked",saveFile)


# Create the statusbar

statusbar = KStatusBar(topwidget)
topwidget.setStatusBar(statusbar)


# Setup and show the main widget

topwidget.show()
app.setMainWidget(topwidget)


# Execute the application

app.execute()


# Clean up

del app