/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

import Qt 4.7
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    id: wrapper;
    width: 15;

    signal wrapperValueChanged(variant newValue);

    PlasmaWidgets.ScrollBar {
        id: embeddedScrollBar;

        anchors.fill: parent;

        onValueChanged: {
            wrapper.wrapperValueChanged(value);
        }
    }

    function setMinimum(min) { embeddedScrollBar.minimum = min; }
    function setMaximum(max) { embeddedScrollBar.maximum = max; }
    function setPageStep(pageStep) { embeddedScrollBar.pageStep = pageStep; }

    states: [
        State {
            name: "hidden";
            PropertyChanges {
                target: wrapper;
                opacity: 0;
            }
        },
        State {
            name: "visible";
            PropertyChanges {
                target: wrapper;
                opacity: 1;
            }
        }
    ]

    transitions:
        Transition {
             NumberAnimation {
                 properties: "opacity";
                 easing.type: Easing.Linear;
                 duration: 500;
             }
        }

}
