/***************************************************************************
 *   Copyright (C) 2020 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <https://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A dashboard.
 *
 * @author Stephane MANKOWSKI
 */
#include "skgdashboardboardwidget.h"

#include <qdom.h>

#include "skgdocument.h"
#include "skginterfaceplugin.h"
#include "skgmainpanel.h"
#include "skgservices.h"
#include "skgtraces.h"
#include "skgdashboardwidget.h"


SKGDashboardboardWidget::SKGDashboardboardWidget(QWidget* iParent, SKGDocument* iDocument)
    : SKGBoardWidget(iParent, iDocument, i18nc("Dashboard widget title", "Sub dashboard")), m_widget(nullptr)
{
    SKGTRACEINFUNC(1)
    m_widget = new SKGDashboardWidget(this, iDocument, getMenu());
    setMainWidget(m_widget);
}

SKGDashboardboardWidget::~SKGDashboardboardWidget()
{
    SKGTRACEINFUNC(1)
    m_widget = nullptr;
}

QString SKGDashboardboardWidget::getState()
{
    SKGTRACEINFUNC(10)
    QDomDocument doc(QStringLiteral("SKGML"));
    doc.setContent(SKGBoardWidget::getState());
    QDomElement root = doc.documentElement();

    // Get state
    if (m_widget != nullptr) {
        root.setAttribute(QStringLiteral("widget"), m_widget->getState());
    }
    return doc.toString();

    return m_widget->getState();
}

void SKGDashboardboardWidget::setState(const QString& iState)
{
    SKGTRACEINFUNC(10)
    SKGBoardWidget::setState(iState);

    QDomDocument doc(QStringLiteral("SKGML"));
    doc.setContent(iState);
    QDomElement root = doc.documentElement();
    QString widget = root.attribute(QStringLiteral("widget"));
    if (widget.isEmpty()) {
        m_widget->setState(iState);
    } else {
        m_widget->setState(widget);
    }
}
