/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgreport.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);

    SKGDocument document1;
    SKGTESTERROR(QStringLiteral("PARAM:initialize"), document1.initialize(), true);

    SKGReport* rep = document1.getReport();
    rep->getPeriod();
    rep->setPeriod(QStringLiteral("2013-01"));
    SKGTEST(QStringLiteral("REP:getMonth"), rep->getPeriod(), QStringLiteral("2013-01"));
    SKGTEST(QStringLiteral("REP:getPreviousMonth"), rep->getPreviousPeriod(), QStringLiteral("2012-12"));

    QString html;
    SKGTESTERROR(QStringLiteral("PARAM:initialize"),  SKGReport::getReportFromTemplate(rep, SKGTest::getTestPath(QStringLiteral("IN")) % "missing.txt", html), false);

    delete rep;


    // End test
    SKGENDTEST();
}
