/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a query creator for skrooge
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgprocesscreator.h"
#include "skgpropertyeditor.h"
#include <qdom.h>
#include "skgpredicatcreator.h"

SKGProcessCreator::SKGProcessCreator(QWidget* iParent):
    QWidget(iParent), m_document(NULL)
{
    ui.setupUi(this);
    ui.addLineBtn->setIcon(KIcon("list-add"));
    // When clicking on the addLine Button, add a new line in the process definition
    connect(ui.addLineBtn, SIGNAL(clicked(bool)), this, SLOT(addLine()));
}

SKGProcessCreator::~SKGProcessCreator()
{
    m_document = NULL;
}

SKGPropertyEditor* SKGProcessCreator::addLine()
{
    // Create a new property line
    SKGPropertyEditor* lineEditor = new SKGPropertyEditor();
    ui.propertyLinesLayout->addWidget(lineEditor);
    // Give the line the appropriate parameters
    lineEditor->setParameters(m_document, m_table, m_listAtts, m_listOtherAtts);
    lineEditor->setupWidgets();
    return lineEditor;
}

void SKGProcessCreator::setParameters(SKGDocument* iDocument, const QString& iTable, const QStringList& iListAttribute, const QStringList& iListOtherAttribute)
{
    m_document = iDocument;
    m_table = iTable;
    m_listAtts = iListAttribute;
    m_listOtherAtts = iListOtherAttribute;
}


void SKGProcessCreator::setXMLCondition(const QString& iXML)
{
    QDomDocument doc("SKGML");
    doc.setContent(iXML);
    QDomElement root = doc.documentElement();

    // Remove all existing lines
    for (int i = 0; ui.propertyLinesLayout->count(); ++i) {
        QLayoutItem* line = ui.propertyLinesLayout->takeAt(i);
        if (line) line->widget()->deleteLater();
    }
    QDomNode l = root.firstChild();
    while (!l.isNull()) {
        QDomElement elementl = l.toElement();
        if (!elementl.isNull()) {
            //Add new line
            SKGPropertyEditor* line = addLine();

            QDomNode n = elementl.firstChild();
            while (!n.isNull()) {
                QDomElement element = n.toElement();
                if (!element.isNull()) {
                    QString attribute = element.attribute("attribute");

                    QDomDocument doc2("SKGML");
                    QDomElement root2 = doc2.createElement("element");
                    doc2.appendChild(root2);
                    root2.setAttribute("operator", element.attribute("operator"));
                    root2.setAttribute("value", element.attribute("value"));
                    root2.setAttribute("value2", element.attribute("value2"));
                    root2.setAttribute("att2", element.attribute("att2"));
                    root2.setAttribute("att2s", element.attribute("att2s"));
                    QString xml = doc2.toString();
                    if (line) line->setXMLCondition(SKGPredicatCreator::getTextFromXml(xml));
                }
                n = n.nextSibling();
            }
        }
        l = l.nextSibling();
    }
}


QString SKGProcessCreator::getXMLCondition()
{
//     QString output;
//
//     QDomDocument doc ( "SKGML" );
//     QDomElement element = doc.createElement ( "element" );
//     doc.appendChild ( element );
//
//     int nbRow=ui.propertyLinesLayout->count();
//     for ( int j=0; j<nbRow; ++j )
//     {
//         SKGPropertyEditor* line = ui.propertyLinesLayout->itemAt(j);
//
//         QDomElement elementLine = doc.createElement ( "element" );
//         element.appendChild ( elementLine );
//
//         QDomComment com=doc.createComment ( "AND" );
//         elementLine.appendChild ( com );
//
//         bool atLeastOne=false;
//
//
//         QDomElement elementElement = doc.createElement ( "element" );
//         elementLine.appendChild ( elementElement );
//
//         elementElement.setAttribute ( "attribute", line->getAttribute() );
//         elementElement.setAttribute ( "operator", line->getOperator() );
//         elementElement.setAttribute ( "value",  line->getValue() );
//         elementElement.setAttribute ( "value2", line->getValue2() );
//         elementElement.setAttribute ( "att2", line->getAtt2() );
//         elementElement.setAttribute ( "att2s", line->getAtt2s() );
//
//     }
//
//     return doc.toString();
    return "";
}

#include "skgprocesscreator.moc"
