/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NEXIF_H_
#define _SOPRANO_NEXIF_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk2 {
    namespace Vocabulary {
        namespace NEXIF {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#
             */
            NEPOMUK_EXPORT QUrl nexifNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#
             */
            NEPOMUK_EXPORT QUrl nrlOntologyGraph();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#Photo 
             * 
             * A photo, an image captured using a camera, an EXIF Image File 
             * Directory. Implementation notes: use nie:copyright to store 
             * copyright notices. 
             */
            NEPOMUK_EXPORT QUrl Photo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#apertureValue 
             * 
             * tagNumber: 37378 
             * The lens aperture. The unit is the APEX value. 
             */
            NEPOMUK_EXPORT QUrl apertureValue();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#artist 
             * 
             * tagNumber: 315 
             * Person who created the image 
             */
            NEPOMUK_EXPORT QUrl artist();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#bitsPerSample 
             * 
             * tagNumber: 258 
             * The number of bits per image component. In this standard each 
             * component of the image is 8 bits, so the value for this tag is 8. 
             * See also SamplesPerPixel. In JPEG compressed data a JPEG marker 
             * is used instead of this tag. 
             */
            NEPOMUK_EXPORT QUrl bitsPerSample();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#brightnessValue 
             * 
             * tagNumber: 37379 
             * The value of brightness. The unit is the APEX value. Ordinarily 
             * it is given in the range of -99.99 to 99.99. Note that if the numerator 
             * of the recorded value is FFFFFFFF.H, Unknown shall be indicated. 
             */
            NEPOMUK_EXPORT QUrl brightnessValue();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#cfaPattern 
             * 
             * tagNumber: 41730 
             * The color filter array (CFA) geometric pattern of the image 
             * sensor when a one-chip color area sensor is used. It does not 
             * apply to all sensing methods. 
             */
            NEPOMUK_EXPORT QUrl cfaPattern();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#colorSpace 
             * 
             * tagNumber: 40961 
             * The color space information tag (ColorSpace) is always recorded 
             * as the color space specifier. Normally sRGB (=1) is used to define 
             * the color space based on the PC monitor conditions and environment. 
             */
            NEPOMUK_EXPORT QUrl colorSpace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#componentsConfiguration 
             * 
             * Information specific to compressed data. The channels of each 
             * component are arranged in order from the 1st component to the 
             * 4th. For uncompressed data the data arrangement is given in 
             * the PhotometricInterpretation tag. However, since PhotometricInterpretation 
             * can only express the order of Y,Cb and Cr, this tag is provided 
             * for cases when compressed data uses components other than Y, 
             * Cb, and Cr and to enable support of other sequences. 
             * tagNumber: 37121 
             */
            NEPOMUK_EXPORT QUrl componentsConfiguration();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#compressedBitsPerPixel 
             * 
             * tagNumber: 37122 
             * Information specific to compressed data. The compression 
             * mode used for a compressed image is indicated in unit bits per 
             * pixel. 
             */
            NEPOMUK_EXPORT QUrl compressedBitsPerPixel();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#compression 
             * 
             * The compression scheme used for the image data. When a primary 
             * image is JPEG compressed, this designation is not necessary 
             * and is omitted. When thumbnails use JPEG compression, this 
             * tag value is set to 6. 
             * tagNumber: 259 
             */
            NEPOMUK_EXPORT QUrl compression();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#contrast 
             * 
             * tagNumber: 41992 
             * The direction of contrast processing applied by the camera 
             * when the image was shot. 
             */
            NEPOMUK_EXPORT QUrl contrast();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#copyright 
             * 
             * tagNumber: 33432 
             * Copyright information. In this standard the tag is used to indicate 
             * both the photographer and editor copyrights. It is the copyright 
             * notice of the person or organization claiming rights to the 
             * image. Deprecated in favor of the more generic nie:copyright. 
             */
            NEPOMUK_EXPORT QUrl copyright();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#customRendered 
             * 
             * The use of special processing on image data, such as rendering 
             * geared to output. When special processing is performed, the 
             * reader is expected to disable or minimize any further processing. 
             * tagNumber: 41985 
             */
            NEPOMUK_EXPORT QUrl customRendered();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#datatype 
             * 
             * The Exif field data type, such as ascii, byte, short etc. 
             */
            NEPOMUK_EXPORT QUrl datatype();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#date 
             * 
             * a date information. Usually saved as YYYY:MM:DD (HH:MM:SS) 
             * format in Exif data, but represented here as W3C-DTF format 
             */
            NEPOMUK_EXPORT QUrl date();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#dateAndOrTime 
             * 
             * An attribute relating to Date and/or Time 
             */
            NEPOMUK_EXPORT QUrl dateAndOrTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#dateTime 
             * 
             * The date and time of image creation. In this standard it is the 
             * date and time the file was changed. 
             * tagNumber: 306 
             */
            NEPOMUK_EXPORT QUrl dateTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#dateTimeDigitized 
             * 
             * The date and time when the image was stored as digital data. If, 
             * for example, an image was captured by DSC and at the same time 
             * the file was recorded, then the DateTimeOriginal and DateTimeDigitized 
             * will have the same contents. 
             * tagNumber: 36868 
             */
            NEPOMUK_EXPORT QUrl dateTimeDigitized();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#dateTimeOriginal 
             * 
             * tagNumber: 36867 
             * The date and time when the original image data was generated. 
             * For a DSC the date and time the picture was taken are recorded. 
             */
            NEPOMUK_EXPORT QUrl dateTimeOriginal();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#deviceSettingDescription 
             * 
             * tagNumber: 41995 
             * Information on the picture-taking conditions of a particular 
             * camera model. The tag is used only to indicate the picture-taking 
             * conditions in the reader. 
             */
            NEPOMUK_EXPORT QUrl deviceSettingDescription();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#digitalZoomRatio 
             * 
             * tagNumber: 41988 
             * The digital zoom ratio when the image was shot. If the numerator 
             * of the recorded value is 0, this indicates that digital zoom 
             * was not used. 
             */
            NEPOMUK_EXPORT QUrl digitalZoomRatio();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#exifAttribute 
             * 
             * A property that connects an IFD (or other resource) to one of 
             * its entries (Exif attribute). Super property which integrates 
             * all Exif tags. Domain definition dropped so that this vocabulary 
             * can be used to describe not only Exif IFD, but also general image. 
             */
            NEPOMUK_EXPORT QUrl exifAttribute();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#exifIFDPointer 
             * 
             * tagNumber: 34665 
             * A pointer to the Exif IFD, which is a set of tags for recording 
             * Exif-specific attribute information. 
             */
            NEPOMUK_EXPORT QUrl exifIFDPointer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#exifVersion 
             * 
             * tagNumber: 36864 
             * Exif Version 
             */
            NEPOMUK_EXPORT QUrl exifVersion();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#exifdata 
             * 
             * An Exif IFD data entry 
             */
            NEPOMUK_EXPORT QUrl exifdata();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#exposureBiasValue 
             * 
             * tagNumber: 37380 
             * The exposure bias. The unit is the APEX value. Ordinarily it 
             * is given in the range of -99.99 to 99.99. 
             */
            NEPOMUK_EXPORT QUrl exposureBiasValue();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#exposureIndex 
             * 
             * The exposure index selected on the camera or input device at 
             * the time the image is captured. 
             * tagNumber: 41493 
             */
            NEPOMUK_EXPORT QUrl exposureIndex();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#exposureMode 
             * 
             * tagNumber: 41986 
             * the exposure mode set when the image was shot. In auto-bracketing 
             * mode, the camera shoots a series of frames of the same scene at 
             * different exposure settings. 
             */
            NEPOMUK_EXPORT QUrl exposureMode();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#exposureProgram 
             * 
             * tagNumber: 34850 
             * The class of the program used by the camera to set exposure when 
             * the picture is taken. 
             */
            NEPOMUK_EXPORT QUrl exposureProgram();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#exposureTime 
             * 
             * tagNumber: 33434 
             * Exposure time, given in seconds (sec). 
             */
            NEPOMUK_EXPORT QUrl exposureTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#fNumber 
             * 
             * tagNumber: 33437 
             * F number 
             */
            NEPOMUK_EXPORT QUrl fNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#fileSource 
             * 
             * The image source. If a DSC recorded the image, this tag value 
             * of this tag always be set to 3, indicating that the image was recorded 
             * on a DSC. 
             * tagNumber: 41728 
             */
            NEPOMUK_EXPORT QUrl fileSource();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#flash 
             * 
             * tagNumber: 37385 
             * The status of flash when the image was shot. 
             */
            NEPOMUK_EXPORT QUrl flash();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#flashEnergy 
             * 
             * tagNumber: 41483 
             * The strobe energy at the time the image is captured, as measured 
             * in Beam Candle Power Seconds (BCPS). 
             */
            NEPOMUK_EXPORT QUrl flashEnergy();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#flashpixVersion 
             * 
             * tagNumber: 40960 
             * The Flashpix format version supported by a FPXR file. If the 
             * FPXR function supports Flashpix format Ver. 1.0, this is indicated 
             * similarly to ExifVersion by recording "0100" as 4-byte ASCII. 
             */
            NEPOMUK_EXPORT QUrl flashpixVersion();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#focalLength 
             * 
             * The actual focal length of the lens, in mm. Conversion is not 
             * made to the focal length of a 35 mm film camera. 
             * tagNumber: 37386 
             */
            NEPOMUK_EXPORT QUrl focalLength();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#focalLengthIn35mmFilm 
             * 
             * The equivalent focal length assuming a 35mm film camera, in 
             * mm. A value of 0 means the focal length is unknown. Note that this 
             * tag differs from the FocalLength tag. 
             * tagNumber: 41989 
             */
            NEPOMUK_EXPORT QUrl focalLengthIn35mmFilm();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#focalPlaneResolutionUnit 
             * 
             * The unit for measuring FocalPlaneXResolution and FocalPlaneYResolution. 
             * This value is the same as the ResolutionUnit. 
             * tagNumber: 41488 
             */
            NEPOMUK_EXPORT QUrl focalPlaneResolutionUnit();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#focalPlaneXResolution 
             * 
             * The number of pixels in the image width (X) direction per FocalPlaneResolutionUnit 
             * on the camera focal plane. 
             * tagNumber: 41486 
             */
            NEPOMUK_EXPORT QUrl focalPlaneXResolution();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#focalPlaneYResolution 
             * 
             * tagNumber: 41487 
             * The number of pixels in the image height (Y) direction per FocalPlaneResolutionUnit 
             * on the camera focal plane. 
             */
            NEPOMUK_EXPORT QUrl focalPlaneYResolution();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gainControl 
             * 
             * tagNumber: 41991 
             * The degree of overall image gain adjustment. 
             */
            NEPOMUK_EXPORT QUrl gainControl();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#geo 
             * 
             * Geometric data such as latitude, longitude and altitude. Usually 
             * saved as rational number. 
             */
            NEPOMUK_EXPORT QUrl geo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gps 
             * 
             * The location where the picture has been made. This property 
             * aggregates values of two properties from the original EXIF 
             * specification: gpsLatitute (tag number 2) and gpsLongitude 
             * (tag number 4), and gpsAltitude (tag number 6). 
             */
            NEPOMUK_EXPORT QUrl gps();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsAltitudeRef 
             * 
             * Indicates the altitude used as the reference altitude. If the 
             * reference is sea level and the altitude is above sea level, 0 
             * is given. If the altitude is below sea level, a value of 1 is given 
             * and the altitude is indicated as an absolute value in the GPSAltitude 
             * tag. The reference unit is meters. 
             * tagNumber: 5 
             */
            NEPOMUK_EXPORT QUrl gpsAltitudeRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsAreaInformation 
             * 
             * A character string recording the name of the GPS area. The first 
             * byte indicates the character code used, and this is followed 
             * by the name of the GPS area. 
             * tagNumber: 28 
             */
            NEPOMUK_EXPORT QUrl gpsAreaInformation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDOP 
             * 
             * The GPS DOP (data degree of precision). An HDOP value is written 
             * during two-dimensional measurement, and PDOP during three-dimensional 
             * measurement. 
             * tagNumber: 11 
             */
            NEPOMUK_EXPORT QUrl gpsDOP();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDateStamp 
             * 
             * tagNumber: 29 
             * date and time information relative to UTC (Coordinated Universal 
             * Time). The record format is "YYYY:MM:DD" while converted to 
             * W3C-DTF to use in RDF 
             */
            NEPOMUK_EXPORT QUrl gpsDateStamp();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDest 
             * 
             * Location of the destination. This property aggregates values 
             * of two other properties from the original exif specification. 
             * gpsDestLatitude (tag number 20) and gpsDestLongitude (tag 
             * number 22) 
             */
            NEPOMUK_EXPORT QUrl gpsDest();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDestBearing 
             * 
             * The bearing to the destination point. The range of values is 
             * from 0.00 to 359.99. 
             * tagNumber: 24 
             */
            NEPOMUK_EXPORT QUrl gpsDestBearing();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDestBearingRef 
             * 
             * Indicates the reference used for giving the bearing to the destination 
             * point. 'T' denotes true direction and 'M' is magnetic direction. 
             * tagNumber: 23 
             */
            NEPOMUK_EXPORT QUrl gpsDestBearingRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDestDistance 
             * 
             * The distance to the destination point. 
             * tagNumber: 26 
             */
            NEPOMUK_EXPORT QUrl gpsDestDistance();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDestDistanceRef 
             * 
             * Indicates the unit used to express the distance to the destination 
             * point. 'K', 'M' and 'N' represent kilometers, miles and knots. 
             * tagNumber: 25 
             */
            NEPOMUK_EXPORT QUrl gpsDestDistanceRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDestLatitudeRef 
             * 
             * tagNumber: 19 
             * Reference for latitude of destination 
             */
            NEPOMUK_EXPORT QUrl gpsDestLatitudeRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDestLongitudeRef 
             * 
             * Reference for longitude of destination 
             * tagNumber: 21 
             */
            NEPOMUK_EXPORT QUrl gpsDestLongitudeRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsDifferential 
             * 
             * tagNumber: 30 
             * Indicates whether differential correction is applied to the 
             * GPS receiver. 
             */
            NEPOMUK_EXPORT QUrl gpsDifferential();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsImgDirection 
             * 
             * tagNumber: 17 
             * The direction of the image when it was captured. The range of 
             * values is from 0.00 to 359.99. 
             */
            NEPOMUK_EXPORT QUrl gpsImgDirection();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsImgDirectionRef 
             * 
             * tagNumber: 16 
             * The reference for giving the direction of the image when it is 
             * captured. 'T' denotes true direction and 'M' is magnetic direction. 
             */
            NEPOMUK_EXPORT QUrl gpsImgDirectionRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsInfo 
             * 
             * An attribute relating to GPS information 
             */
            NEPOMUK_EXPORT QUrl gpsInfo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsInfoIFDPointer 
             * 
             * A pointer to the GPS IFD, which is a set of tags for recording GPS 
             * information. 
             * tagNumber: 34853 
             */
            NEPOMUK_EXPORT QUrl gpsInfoIFDPointer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsLatitudeRef 
             * 
             * tagNumber: 1 
             * Indicates whether the latitude is north or south latitude. 
             * The ASCII value 'N' indicates north latitude, and 'S' is south 
             * latitude. 
             */
            NEPOMUK_EXPORT QUrl gpsLatitudeRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsLongitudeRef 
             * 
             * tagNumber: 3 
             * Indicates whether the longitude is east or west longitude. 
             * ASCII 'E' indicates east longitude, and 'W' is west longitude. 
             */
            NEPOMUK_EXPORT QUrl gpsLongitudeRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsMapDatum 
             * 
             * The geodetic survey data used by the GPS receiver. If the survey 
             * data is restricted to Japan, the value of this tag is 'TOKYO' 
             * or 'WGS-84'. If a GPS Info tag is recorded, it is strongly recommended 
             * that this tag be recorded. 
             * tagNumber: 18 
             */
            NEPOMUK_EXPORT QUrl gpsMapDatum();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsMeasureMode 
             * 
             * The GPS measurement mode. '2' means two-dimensional measurement 
             * and '3' means three-dimensional measurement is in progress. 
             * tagNumber: 10 
             */
            NEPOMUK_EXPORT QUrl gpsMeasureMode();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsProcessingMethod 
             * 
             * tagNumber: 27 
             * A character string recording the name of the method used for 
             * location finding. The first byte indicates the character code 
             * used, and this is followed by the name of the method. 
             */
            NEPOMUK_EXPORT QUrl gpsProcessingMethod();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsSatellites 
             * 
             * tagNumber: 8 
             * The GPS satellites used for measurements. This tag can be used 
             * to describe the number of satellites, their ID number, angle 
             * of elevation, azimuth, SNR and other information in ASCII notation. 
             * The format is not specified. If the GPS receiver is incapable 
             * of taking measurements, value of the tag shall be set to NULL. 
             */
            NEPOMUK_EXPORT QUrl gpsSatellites();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsSpeed 
             * 
             * The speed of GPS receiver movement. 
             * tagNumber: 13 
             */
            NEPOMUK_EXPORT QUrl gpsSpeed();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsSpeedRef 
             * 
             * tagNumber: 12 
             * The unit used to express the GPS receiver speed of movement. 
             * 'K' 'M' and 'N' represents kilometers per hour, miles per hour, 
             * and knots. 
             */
            NEPOMUK_EXPORT QUrl gpsSpeedRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsStatus 
             * 
             * tagNumber: 9 
             * The status of the GPS receiver when the image is recorded. 'A' 
             * means measurement is in progress, and 'V' means the measurement 
             * is Interoperability. 
             */
            NEPOMUK_EXPORT QUrl gpsStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsTimeStamp 
             * 
             * tagNumber: 7 
             * The time as UTC (Coordinated Universal Time). TimeStamp is 
             * expressed as three RATIONAL values giving the hour, minute, 
             * and second. 
             */
            NEPOMUK_EXPORT QUrl gpsTimeStamp();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsTrack 
             * 
             * The direction of GPS receiver movement. The range of values 
             * is from 0.00 to 359.99. 
             * tagNumber: 15 
             */
            NEPOMUK_EXPORT QUrl gpsTrack();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsTrackRef 
             * 
             * tagNumber: 14 
             * The reference for giving the direction of GPS receiver movement. 
             * 'T' denotes true direction and 'M' is magnetic direction. 
             */
            NEPOMUK_EXPORT QUrl gpsTrackRef();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#gpsVersionID 
             * 
             * The version of GPSInfoIFD. The version is given as 2.2.0.0. 
             * This tag is mandatory when GPSInfo tag is present. 
             * tagNumber: 0 
             */
            NEPOMUK_EXPORT QUrl gpsVersionID();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#height 
             * 
             * Height of an object 
             */
            NEPOMUK_EXPORT QUrl height();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#ifdPointer 
             * 
             * A tag that refers a child IFD 
             */
            NEPOMUK_EXPORT QUrl ifdPointer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#imageConfig 
             * 
             * An attribute relating to Image Configuration 
             */
            NEPOMUK_EXPORT QUrl imageConfig();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#imageDataCharacter 
             * 
             * An attribute relating to image data characteristics 
             */
            NEPOMUK_EXPORT QUrl imageDataCharacter();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#imageDataStruct 
             * 
             * An attribute relating to image data structure 
             */
            NEPOMUK_EXPORT QUrl imageDataStruct();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#imageDescription 
             * 
             * tagNumber: 270 
             * A character string giving the title of the image. It may be a comment 
             * such as "1988 company picnic" or the like. Two-byte character 
             * codes cannot be used. When a 2-byte code is necessary, the Exif 
             * Private tag UserComment is to be used. 
             */
            NEPOMUK_EXPORT QUrl imageDescription();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#imageLength 
             * 
             * tagNumber: 257 
             * Image height. The number of rows of image data. In JPEG compressed 
             * data a JPEG marker is used. 
             */
            NEPOMUK_EXPORT QUrl imageLength();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#imageUniqueID 
             * 
             * An identifier assigned uniquely to each image. It is recorded 
             * as an ASCII string equivalent to hexadecimal notation and 128-bit 
             * fixed length. 
             * tagNumber: 42016 
             */
            NEPOMUK_EXPORT QUrl imageUniqueID();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#imageWidth 
             * 
             * tagNumber: 256 
             * Image width. The number of columns of image data, equal to the 
             * number of pixels per row. In JPEG compressed data a JPEG marker 
             * is used instead of this tag. 
             */
            NEPOMUK_EXPORT QUrl imageWidth();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#interopInfo 
             * 
             * An attribute relating to Interoperability. Tags stored in 
             * Interoperability IFD may be defined dependently to each Interoperability 
             * rule. 
             */
            NEPOMUK_EXPORT QUrl interopInfo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#interoperabilityIFDPointer 
             * 
             * A pointer to the Interoperability IFD, which is composed of 
             * tags storing the information to ensure the Interoperability 
             * tagNumber: 40965 
             */
            NEPOMUK_EXPORT QUrl interoperabilityIFDPointer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#interoperabilityIndex 
             * 
             * Indicates the identification of the Interoperability rule. 
             * 'R98' = conforming to R98 file specification of Recommended 
             * Exif Interoperability Rules (ExifR98) or to DCF basic file 
             * stipulated by Design Rule for Camera File System. 'THM' = conforming 
             * to DCF thumbnail file stipulated by Design rule for Camera File 
             * System. 
             * tagNumber: 1 
             */
            NEPOMUK_EXPORT QUrl interoperabilityIndex();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#interoperabilityVersion 
             * 
             * tagNumber: 2 
             * Interoperability Version 
             */
            NEPOMUK_EXPORT QUrl interoperabilityVersion();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#isoSpeedRatings 
             * 
             * Indicates the ISO Speed and ISO Latitude of the camera or input 
             * device as specified in ISO 12232. 
             * tagNumber: 34855 
             */
            NEPOMUK_EXPORT QUrl isoSpeedRatings();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#jpegInterchangeFormat 
             * 
             * tagNumber: 513 
             * The offset to the start byte (SOI) of JPEG compressed thumbnail 
             * data. This is not used for primary image JPEG data. 
             */
            NEPOMUK_EXPORT QUrl jpegInterchangeFormat();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#jpegInterchangeFormatLength 
             * 
             * The number of bytes of JPEG compressed thumbnail data. This 
             * is not used for primary image JPEG data. 
             * tagNumber: 514 
             */
            NEPOMUK_EXPORT QUrl jpegInterchangeFormatLength();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#length 
             * 
             * Length of an object. Could be a subProperty of other general 
             * schema. 
             */
            NEPOMUK_EXPORT QUrl length();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#lightSource 
             * 
             * tagNumber: 37384 
             * Light source such as Daylight, Tungsten, Flash etc. 
             */
            NEPOMUK_EXPORT QUrl lightSource();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#make 
             * 
             * Manufacturer of image input equipment 
             * tagNumber: 271 
             */
            NEPOMUK_EXPORT QUrl make();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#makerNote 
             * 
             * Manufacturer notes 
             * tagNumber: 37500 
             */
            NEPOMUK_EXPORT QUrl makerNote();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#maxApertureValue 
             * 
             * tagNumber: 37381 
             * The smallest F number of the lens. The unit is the APEX value. 
             * Ordinarily it is given in the range of 00.00 to 99.99, but it is 
             * not limited to this range. 
             */
            NEPOMUK_EXPORT QUrl maxApertureValue();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#meter 
             * 
             * A length with unit of meter 
             */
            NEPOMUK_EXPORT QUrl meter();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#meteringMode 
             * 
             * Metering mode, such as CenterWeightedAverage, Spot, MultiSpot,Pattern, 
             * Partial etc. 
             * tagNumber: 37383 
             */
            NEPOMUK_EXPORT QUrl meteringMode();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#mm 
             * 
             * A length with unit of mm 
             */
            NEPOMUK_EXPORT QUrl mm();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#model 
             * 
             * tagNumber: 272 
             * Model of image input equipment 
             */
            NEPOMUK_EXPORT QUrl model();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#oecf 
             * 
             * tagNumber: 34856 
             * Indicates the Opto-Electric Conversion Function (OECF) specified 
             * in ISO 14524. OECF is the relationship between the camera optical 
             * input and the image values. 
             */
            NEPOMUK_EXPORT QUrl oecf();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#orientation 
             * 
             * The image orientation viewed in terms of rows and columns. As 
             * defined in the EXIF specification this is a number between 1 
             * and 8. 
             */
            NEPOMUK_EXPORT QUrl orientation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#photometricInterpretation 
             * 
             * Pixel composition. In JPEG compressed data a JPEG marker is 
             * used instead of this tag. 
             * tagNumber: 262 
             */
            NEPOMUK_EXPORT QUrl photometricInterpretation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#pictTaking 
             * 
             * An attribute relating to Picture-Taking Conditions 
             */
            NEPOMUK_EXPORT QUrl pictTaking();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#pimBrightness 
             * 
             * Brightness info for print image matching 
             * tagNumber: 10 
             */
            NEPOMUK_EXPORT QUrl pimBrightness();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#pimColorBalance 
             * 
             * tagNumber: 11 
             * ColorBalance info for print image matching 
             */
            NEPOMUK_EXPORT QUrl pimColorBalance();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#pimContrast 
             * 
             * tagNumber: 9 
             * Contrast info for print image matching 
             */
            NEPOMUK_EXPORT QUrl pimContrast();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#pimInfo 
             * 
             * An attribute relating to print image matching 
             */
            NEPOMUK_EXPORT QUrl pimInfo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#pimSaturation 
             * 
             * tagNumber: 12 
             * Saturation info for print image matching 
             */
            NEPOMUK_EXPORT QUrl pimSaturation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#pimSharpness 
             * 
             * Sharpness info for print image matching 
             * tagNumber: 13 
             */
            NEPOMUK_EXPORT QUrl pimSharpness();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#pixelXDimension 
             * 
             * Information specific to compressed data. When a compressed 
             * file is recorded, the valid width of the meaningful image shall 
             * be recorded in this tag, whether or not there is padding data 
             * or a restart marker. This tag should not exist in an uncompressed 
             * file. 
             * tagNumber: 40962 
             */
            NEPOMUK_EXPORT QUrl pixelXDimension();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#pixelYDimension 
             * 
             * Information specific to compressed data. When a compressed 
             * file is recorded, the valid height of the meaningful image shall 
             * be recorded in this tag, whether or not there is padding data 
             * or a restart marker. This tag should not exist in an uncompressed 
             * file. Since data padding is unnecessary in the vertical direction, 
             * the number of lines recorded in this valid image height tag will 
             * in fact be the same as that recorded in the SOF. 
             * tagNumber: 40963 
             */
            NEPOMUK_EXPORT QUrl pixelYDimension();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#planarConfiguration 
             * 
             * Indicates whether pixel components are recorded in chunky 
             * or planar format. In JPEG compressed files a JPEG marker is used 
             * instead of this tag. If this field does not exist, the TIFF default 
             * of 1 (chunky) is assumed. 
             * tagNumber: 284 
             */
            NEPOMUK_EXPORT QUrl planarConfiguration();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#primaryChromaticities 
             * 
             * The chromaticity of the three primary colors of the image. Normally 
             * this tag is not necessary, since color space is specified in 
             * the color space information tag (ColorSpace). 
             * tagNumber: 319 
             */
            NEPOMUK_EXPORT QUrl primaryChromaticities();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#printImageMatchingIFDPointer 
             * 
             * tagNumber: 50341 
             * A pointer to the print image matching IFD 
             */
            NEPOMUK_EXPORT QUrl printImageMatchingIFDPointer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#recOffset 
             * 
             * An attribute relating to recording offset 
             */
            NEPOMUK_EXPORT QUrl recOffset();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#referenceBlackWhite 
             * 
             * tagNumber: 532 
             * The reference black point value and reference white point value. 
             * The color space is declared in a color space information tag, 
             * with the default being the value that gives the optimal image 
             * characteristics Interoperability these conditions. 
             */
            NEPOMUK_EXPORT QUrl referenceBlackWhite();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#relatedFile 
             * 
             * Tag Relating to Related File Information 
             */
            NEPOMUK_EXPORT QUrl relatedFile();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#relatedImageFileFormat 
             * 
             * Related image file format 
             * tagNumber: 4096 
             */
            NEPOMUK_EXPORT QUrl relatedImageFileFormat();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#relatedImageLength 
             * 
             * Related image length 
             * tagNumber: 4098 
             */
            NEPOMUK_EXPORT QUrl relatedImageLength();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#relatedImageWidth 
             * 
             * tagNumber: 4097 
             * Related image width 
             */
            NEPOMUK_EXPORT QUrl relatedImageWidth();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#relatedSoundFile 
             * 
             * Related audio file 
             * tagNumber: 40964 
             */
            NEPOMUK_EXPORT QUrl relatedSoundFile();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#resolution 
             * 
             * a rational number representing a resolution. Could be a subProperty 
             * of other general schema. 
             */
            NEPOMUK_EXPORT QUrl resolution();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#resolutionUnit 
             * 
             * tagNumber: 296 
             * The unit for measuring XResolution and YResolution. The same 
             * unit is used for both XResolution and YResolution. If the image 
             * resolution in unknown, 2 (inches) is designated. 
             */
            NEPOMUK_EXPORT QUrl resolutionUnit();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#rowsPerStrip 
             * 
             * tagNumber: 278 
             * The number of rows per strip. This is the number of rows in the 
             * image of one strip when an image is divided into strips. With 
             * JPEG compressed data this designation is not needed and is omitted. 
             */
            NEPOMUK_EXPORT QUrl rowsPerStrip();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#samplesPerPixel 
             * 
             * The number of components per pixel. Since this standard applies 
             * to RGB and YCbCr images, the value set for this tag is 3. In JPEG 
             * compressed data a JPEG marker is used instead of this tag. 
             * tagNumber: 277 
             */
            NEPOMUK_EXPORT QUrl samplesPerPixel();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#saturation 
             * 
             * The direction of saturation processing applied by the camera 
             * when the image was shot. 
             * tagNumber: 41993 
             */
            NEPOMUK_EXPORT QUrl saturation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#sceneCaptureType 
             * 
             * tagNumber: 41990 
             * The type of scene that was shot. It can also be used to record the 
             * mode in which the image was shot, such as Landscape, Portrait 
             * etc. Note that this differs from the scene type (SceneType) 
             * tag. 
             */
            NEPOMUK_EXPORT QUrl sceneCaptureType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#sceneType 
             * 
             * tagNumber: 41729 
             * The type of scene. If a DSC recorded the image, this tag value 
             * shall always be set to 1, indicating that the image was directly 
             * photographed. 
             */
            NEPOMUK_EXPORT QUrl sceneType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#seconds 
             * 
             * a mesurement of time length with unit of second 
             */
            NEPOMUK_EXPORT QUrl seconds();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#sensingMethod 
             * 
             * tagNumber: 41495 
             * The image sensor type on the camera or input device, such as One-chip 
             * color area sensor etc. 
             */
            NEPOMUK_EXPORT QUrl sensingMethod();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#sharpness 
             * 
             * tagNumber: 41994 
             * The direction of sharpness processing applied by the camera 
             * when the image was shot. 
             */
            NEPOMUK_EXPORT QUrl sharpness();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#shutterSpeedValue 
             * 
             * tagNumber: 37377 
             * Shutter speed. The unit is the APEX (Additive System of Photographic 
             * Exposure) setting 
             */
            NEPOMUK_EXPORT QUrl shutterSpeedValue();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#software 
             * 
             * tagNumber: 305 
             * The name and version of the software or firmware of the camera 
             * or image input device used to generate the image. 
             */
            NEPOMUK_EXPORT QUrl software();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#spatialFrequencyResponse 
             * 
             * This tag records the camera or input device spatial frequency 
             * table and SFR values in the direction of image width, image height, 
             * and diagonal direction, as specified in ISO 12233. 
             * tagNumber: 41484 
             */
            NEPOMUK_EXPORT QUrl spatialFrequencyResponse();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#spectralSensitivity 
             * 
             * Indicates the spectral sensitivity of each channel of the camera 
             * used. The tag value is an ASCII string compatible with the standard 
             * developed by the ASTM Technical committee. 
             * tagNumber: 34852 
             */
            NEPOMUK_EXPORT QUrl spectralSensitivity();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#stripByteCounts 
             * 
             * tagNumber: 279 
             * The total number of bytes in each strip. With JPEG compressed 
             * data this designation is not needed and is omitted. 
             */
            NEPOMUK_EXPORT QUrl stripByteCounts();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#stripOffsets 
             * 
             * For each strip, the byte offset of that strip. With JPEG compressed 
             * data this designation is not needed and is omitted. 
             * tagNumber: 273 
             */
            NEPOMUK_EXPORT QUrl stripOffsets();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#subSecTime 
             * 
             * tagNumber: 37520 
             * DateTime subseconds 
             */
            NEPOMUK_EXPORT QUrl subSecTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#subSecTimeDigitized 
             * 
             * tagNumber: 37522 
             * DateTimeDigitized subseconds 
             */
            NEPOMUK_EXPORT QUrl subSecTimeDigitized();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#subSecTimeOriginal 
             * 
             * tagNumber: 37521 
             * DateTimeOriginal subseconds 
             */
            NEPOMUK_EXPORT QUrl subSecTimeOriginal();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#subjectArea 
             * 
             * tagNumber: 37396 
             * The location and area of the main subject in the overall scene. 
             */
            NEPOMUK_EXPORT QUrl subjectArea();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#subjectDistance 
             * 
             * tagNumber: 37382 
             * The distance to the subject, given in meters. Note that if the 
             * numerator of the recorded value is FFFFFFFF.H, Infinity shall 
             * be indicated; and if the numerator is 0, Distance unknown shall 
             * be indicated. 
             */
            NEPOMUK_EXPORT QUrl subjectDistance();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#subjectDistanceRange 
             * 
             * The distance to the subject, such as Macro, Close View or Distant 
             * View. 
             * tagNumber: 41996 
             */
            NEPOMUK_EXPORT QUrl subjectDistanceRange();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#subjectLocation 
             * 
             * The location of the main subject in the scene. The value of this 
             * tag represents the pixel at the center of the main subject relative 
             * to the left edge, prior to rotation processing as per the Rotation 
             * tag. The first value indicates the X column number and second 
             * indicates the Y row number. 
             * tagNumber: 41492 
             */
            NEPOMUK_EXPORT QUrl subjectLocation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#subsecond 
             */
            NEPOMUK_EXPORT QUrl subsecond();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#subseconds 
             * 
             * A tag used to record fractions of seconds for a date property 
             */
            NEPOMUK_EXPORT QUrl subseconds();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#tagNumber 
             * 
             * The Exif tag number (for this schema definition) 
             */
            NEPOMUK_EXPORT QUrl tagNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#tagid 
             * 
             * The Exif tag number with context prefix, such as IFD type or maker 
             * name (for this schema definition) 
             */
            NEPOMUK_EXPORT QUrl tagid();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#transferFunction 
             * 
             * tagNumber: 301 
             * A transfer function for the image, described in tabular style. 
             * Normally this tag is not necessary, since color space is specified 
             * in the color space information tag (ColorSpace). 
             */
            NEPOMUK_EXPORT QUrl transferFunction();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#unknown 
             * 
             * An Exif tag whose meaning is not known 
             */
            NEPOMUK_EXPORT QUrl unknown();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#userComment 
             * 
             * tagNumber: 37510 
             * A tag for Exif users to write keywords or comments on the image 
             * besides those in ImageDescription, and without the character 
             * code limitations of the ImageDescription tag. The character 
             * code used in the UserComment tag is identified based on an ID 
             * code in a fixed 8-byte area at the start of the tag data area. 
             */
            NEPOMUK_EXPORT QUrl userComment();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#userInfo 
             * 
             * An attribute relating to User Information 
             */
            NEPOMUK_EXPORT QUrl userInfo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#versionInfo 
             * 
             * An attribute relating to Version 
             */
            NEPOMUK_EXPORT QUrl versionInfo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#whiteBalance 
             * 
             * tagNumber: 41987 
             * The white balance mode set when the image was shot. 
             */
            NEPOMUK_EXPORT QUrl whiteBalance();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#whitePoint 
             * 
             * The chromaticity of the white point of the image. Normally this 
             * tag is not necessary, since color space is specified in the color 
             * space information tag (ColorSpace). 
             * tagNumber: 318 
             */
            NEPOMUK_EXPORT QUrl whitePoint();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#width 
             * 
             * Width of an object 
             */
            NEPOMUK_EXPORT QUrl width();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#xResolution 
             * 
             * The number of pixels per ResolutionUnit in the ImageWidth direction. 
             * When the image resolution is unknown, 72 [dpi] is designated. 
             * tagNumber: 282 
             */
            NEPOMUK_EXPORT QUrl xResolution();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#yCbCrCoefficients 
             * 
             * tagNumber: 529 
             * The matrix coefficients for transformation from RGB to YCbCr 
             * image data. 
             */
            NEPOMUK_EXPORT QUrl yCbCrCoefficients();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#yCbCrPositioning 
             * 
             * The position of chrominance components in relation to the luminance 
             * component. This field is designated only for JPEG compressed 
             * data or uncompressed YCbCr data. 
             * tagNumber: 531 
             */
            NEPOMUK_EXPORT QUrl yCbCrPositioning();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#yCbCrSubSampling 
             * 
             * The sampling ratio of chrominance components in relation to 
             * the luminance component. In JPEG compressed data a JPEG marker 
             * is used instead of this tag. 
             * tagNumber: 530 
             */
            NEPOMUK_EXPORT QUrl yCbCrSubSampling();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#yResolution 
             * 
             * tagNumber: 283 
             * The number of pixels per ResolutionUnit in the ImageLength 
             * direction. The same value as XResolution is designated. 
             */
            NEPOMUK_EXPORT QUrl yResolution();
        }
    }
}

#endif
