/*
    This file is part of Contact Editor.

    SPDX-FileCopyrightText: 2016 eyeOS S.L.U., a Telefonica company, sales@eyeos.com
    SPDX-FileCopyrightText: 2016-2020 Laurent Montel <montel.org>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef MESSAGINGLISTWIDGET_H
#define MESSAGINGLISTWIDGET_H

#include <QWidget>
namespace KContacts {
class Addressee;
}
namespace ContactEditor {
class MessagingWidgetLister;
class MessagingListWidget : public QWidget
{
    Q_OBJECT
public:
    explicit MessagingListWidget(QWidget *parent = nullptr);
    ~MessagingListWidget();

    void loadContact(const KContacts::Addressee &contact);
    void storeContact(KContacts::Addressee &contact) const;
    void setReadOnly(bool readOnly);

private:
    ContactEditor::MessagingWidgetLister *mMessagingWidgetLister = nullptr;
};
}
#endif // MAILISTWIDGET_H
