#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
""":synopsis: Encoders for email message payloads.


When creating :class:`~email.message.Message` objects from scratch, you often
need to encode the payloads for transport through compliant mail servers. This
is especially true for :mimetype:`image/\*` and :mimetype:`text/\*` type messages
containing binary data.

The :mod:`email` package provides some convenient encodings in its
:mod:`encoders` module.  These encoders are actually used by the
:class:`~email.mime.audio.MIMEAudio` and :class:`~email.mime.image.MIMEImage`
class constructors to provide default encodings.  All encoder functions take
exactly one argument, the message object to encode.  They usually extract the
payload, encode it, and reset the payload to this newly encoded value.  They
should also set the :mailheader:`Content-Transfer-Encoding` header as appropriate.

Here are the encoding functions provided:


"""
def encode_quopri(msg):
	"""
	Encodes the payload into quoted-printable form and sets the
	:mailheader:`Content-Transfer-Encoding` header to ``quoted-printable`` [#]_.
	This is a good encoding to use when most of your payload is normal printable
	data, but contains a few unprintable characters.
	
	
	"""
	pass
	
def encode_base64(msg):
	"""
	Encodes the payload into base64 form and sets the
	:mailheader:`Content-Transfer-Encoding` header to ``base64``.  This is a good
	encoding to use when most of your payload is unprintable data since it is a more
	compact form than quoted-printable.  The drawback of base64 encoding is that it
	renders the text non-human readable.
	
	
	"""
	pass
	
def encode_7or8bit(msg):
	"""
	This doesn't actually modify the message's payload, but it does set the
	:mailheader:`Content-Transfer-Encoding` header to either ``7bit`` or ``8bit`` as
	appropriate, based on the payload data.
	
	
	"""
	pass
	
def encode_noop(msg):
	"""
	This does nothing; it doesn't even set the
	:mailheader:`Content-Transfer-Encoding` header.
	
	"""
	pass
	
