#ifndef THUMBNAILCACHELOCATOR_H
#define THUMBNAILCACHELOCATOR_H

#include <qstring.h>
#include <qdir.h>
#include <kmdcodec.h>
#include <kstandarddirs.h>
#include <kio/jobclasses.h>
#include <kurl.h>

class ThumbnailCacheLocator {

public:

    static void locateCache(const QString& folder,
                            QString& thumbSmallCacheDir,
                            QString& thumbMediumCacheDir,
                            QString& thumbLargeCacheDir) {

        QString thumbCacheDir(folder);
        thumbCacheDir = QDir::cleanDirPath(thumbCacheDir);

        // Generate the thumbnail dir name
        KMD5 md5( QFile::encodeName(KURL(thumbCacheDir).url()) );
        QCString hash = md5.hexDigest();
        QString thumbPath = QString::fromLatin1( hash.data(), 4 )
                            + "/" +
                            QString::fromLatin1( hash.data()+4, 4 )
                            + "/" +
                            QString::fromLatin1( hash.data()+8 )
                            + "/";

        // Create the thumbnail cache dirs
        thumbSmallCacheDir = locateLocal( "thumbnails",
                                          thumbPath + "60" + "/" );
        thumbMediumCacheDir = locateLocal( "thumbnails",
                                           thumbPath + "large" + "/" );
        thumbLargeCacheDir = locateLocal( "thumbnails",
                                          thumbPath + "huge" + "/" );

    }

    static void cleanCache() {
        QString thumbPath("digikam/");
        QString thumbCacheDir = locateLocal( "thumbnails", thumbPath);
        //KIO::DeleteJob* job=KIO::del(KURL(thumbCacheDir,false));
    }

};


#endif
