#ifndef GPHOTO_COMMANDS_H
#define GPHOTO_COMMANDS_H

#include <qstring.h>
#include "thumbnailsize.h"

class Gphoto_Command {

public:

  enum Type {
    Init, GetSubFolders, MakeFolder,
    DeleteFolder, GetImagesInfo, GetThumbNail,
    DownloadImage, DeleteImage, OpenImage,
    UploadImage, GetInfo
  };

  Gphoto_Command(Type type) : _type(type) {}

  Type type() const { return _type; }

private:

  Type _type;

};



class Gphoto_Command_GetSubFolders : public Gphoto_Command {

public:

  Gphoto_Command_GetSubFolders(const QString& parentFolder)
    : Gphoto_Command(GetSubFolders),
      _parentFolder(parentFolder)
  {}

  QString parentFolder() const { return _parentFolder; }

private:

  QString _parentFolder;

};

class Gphoto_Command_MakeFolder : public Gphoto_Command {

public:

  Gphoto_Command_MakeFolder(const QString& parentFolder,
			    const QString& newFolderName)
    : Gphoto_Command(MakeFolder),
      _parentFolder(parentFolder),
      _newFolderName(newFolderName)
  {}

private:

  QString _parentFolder;
  QString _newFolderName;

};

class Gphoto_Command_DeleteFolder : public Gphoto_Command {

public:

  Gphoto_Command_DeleteFolder(const QString& delFolderName)
    : Gphoto_Command(DeleteFolder),
      _delFolderName(delFolderName)
  {}

private:

  QString _delFolderName;

};

class Gphoto_Command_GetThumbNail : public Gphoto_Command {

public:

  Gphoto_Command_GetThumbNail(const QString& parentFolder,
			      const QString& imageName)
    : Gphoto_Command(GetThumbNail),
      _parentFolder(parentFolder),
      _imageName(imageName)
  {}

  QString parentFolder() const { return _parentFolder; }
  QString imageName() const { return _imageName; }

private:

  QString _parentFolder;
  QString _imageName;

};


class Gphoto_Command_GetImagesInfo : public Gphoto_Command {

public:

    Gphoto_Command_GetImagesInfo(const QString& parentFolder)
        : Gphoto_Command(GetImagesInfo),
          _parentFolder(parentFolder)
        {}

    QString parentFolder() const { return _parentFolder; }

private:

    QString _parentFolder;

};




class Gphoto_Command_DownloadImage : public Gphoto_Command {

public:

  Gphoto_Command_DownloadImage(const QString& parentFolder,
			       const QString& imageName,
			       const QString& saveFileName)
    : Gphoto_Command(DownloadImage),
      _parentFolder(parentFolder),
      _imageName(imageName),
      _saveFileName(saveFileName)
  {}

  QString parentFolder() const { return _parentFolder; }
  QString imageName() const { return _imageName; }
  QString saveFileName() const { return _saveFileName; }

private:

  QString _parentFolder;
  QString _imageName;
  QString _saveFileName;

};

class Gphoto_Command_DeleteImage : public Gphoto_Command {

public:

  Gphoto_Command_DeleteImage(const QString& parentFolder,
			       const QString& imageName)
    : Gphoto_Command(DeleteImage),
      _parentFolder(parentFolder),
      _imageName(imageName)
  {}

  QString parentFolder() const { return _parentFolder; }
  QString imageName() const { return _imageName; }

private:

  QString _parentFolder;
  QString _imageName;

};

class Gphoto_Command_OpenImage : public Gphoto_Command {

public:

    Gphoto_Command_OpenImage(const QString& parentFolder,
                             const QString& imageName)
        : Gphoto_Command(OpenImage),
          _parentFolder(parentFolder),
          _imageName(imageName)
        {}

    QString parentFolder() const { return _parentFolder; }
    QString imageName() const { return _imageName; }


private:

    QString _parentFolder;
    QString _imageName;

};


class Gphoto_Command_UploadImage : public Gphoto_Command {

public:

    Gphoto_Command_UploadImage(const QString& parentFolder,
                               const QString& localImagePath,
                               const QString& uploadName)
        : Gphoto_Command(UploadImage),
          _parentFolder(parentFolder),
          _localImagePath(localImagePath),
          _uploadName(uploadName)
        {}

    QString parentFolder() const { return _parentFolder; }
    QString localImagePath() const { return _localImagePath; }
    QString uploadName() const { return _uploadName; }

private:

    QString _parentFolder;
    QString _localImagePath;
    QString _uploadName;

};


class Gphoto_Command_GetInfo : public Gphoto_Command {

public:

    Gphoto_Command_GetInfo() : Gphoto_Command(GetInfo)
        {}

};

#endif
