/***************************************************************************
                          digikam.cpp  -  description
                             -------------------
    begin                : Thu Jul 18 14:58:17 CDT 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>

#include <klocale.h>
#include <ksimpleconfig.h>
#include <kconfig.h>
#include <kstatusbar.h>
#include <kprogress.h>
#include <kaction.h>
#include <kstdaction.h>

#include "digikamview.h"
#include "setup.h"
#include "generalsettings.h"
#include "camerasettings.h"

#include "digikam.h"


Digikam::Digikam()
    : KMainWindow( 0, "Digikam" )
{
    config=kapp->config();

    mView = NULL;
    mStatusBar = NULL;
    mProgressBar = NULL;

    setupView();
    setupActions();
    setupConnections();

    setAutoSaveSettings();
    applyMainWindowSettings (config);

}

Digikam::~Digikam()
{
    if (mView)
        delete mView;
}


void Digikam::setupView()
{

    mStatusBar = statusBar();
    mStatusBar->insertItem(i18n("Ready"), 0, 7, false);
    mStatusBar->setItemAlignment (0, AlignLeft | AlignVCenter);
    QLabel *spacer = new  QLabel(mStatusBar);
    mStatusBar->addWidget(spacer, 1, false);
    mProgressBar = new KProgress(mStatusBar);
    mProgressBar->setTotalSteps(100);
    mStatusBar->addWidget( mProgressBar, 5, false);

    mView = new DigikamView(this);

    GeneralSettings genSettings;
    genSettings.readSettings();

    mThumbnailSize.setSize(genSettings.getDefaultIconSize());

    mView->applyGeneralSettings(genSettings);

    setCentralWidget(mView);

    slot_resetStatusBar();

}

void Digikam::setupActions()
{

    albumNewAction = new KAction(i18n("New Album"),
                                 "folder_new", 0,
                                 mView, SLOT(slot_createNewAlbum()),
                                 actionCollection(),"album_new");
    albumNewAction->setWhatsThis(i18n("Create a New Photo Album"));

    albumDeleteAction = new KAction(i18n("Delete Album"),
                                 "editdelete", 0,
                                 mView, SLOT(slot_deleteAlbum()),
                                 actionCollection(),"album_delete");
    albumDeleteAction->setWhatsThis(i18n("Delete Selected Album"));

    albumSlideShowAction = new KAction(i18n("SlideShow"),
                                 0, mView, SLOT(slot_albumSlideShow()),
                                 actionCollection(),"album_slideShow");
    albumSlideShowAction->setWhatsThis(i18n("Show SlideShow of selected or all images in the Current Album"));

    albumRegenerateThumbnailsAction = new KAction(i18n("Regenerate Thumbnails"),
                                            "image", 0,
                                            mView, SLOT(slot_albumRegenerateThumbnails()),
                                            actionCollection(),"album_thumbsRefresh");
    albumRegenerateThumbnailsAction->setWhatsThis(i18n("Recreate Thumbnails in the Current Album"));

    albumPauseThumbnailsAction = new KToggleAction(i18n("Pause Thumbnail Generation"),
                                                   0, mView, SLOT(slot_albumPauseThumbnails()),
                                                   actionCollection(),"album_thumbsPause");
    albumPauseThumbnailsAction->setWhatsThis(i18n("Pause generation of thumbnails"));

    albumRefreshAction = new KAction(i18n("Refresh Album"), "reload", 0,
                                     mView, SLOT(slot_albumRefresh()),
                                     actionCollection(), "album_refresh");
    albumRefreshAction->setWhatsThis(i18n("Refresh Current Album"));


    // -------------------------------------------------------------------------

    camConnectAction = new KAction(i18n("Connect"),
                                   "connect_established", 0,
                                   mView, SLOT( slot_cameraConnect() ),
                                   actionCollection(),"cam_connect");
    camConnectAction->setWhatsThis( i18n("Establish Connection with the Camera") );

    // -------------------------------------------------------------------------

    camDisconnectAction = new KAction(i18n("Disconnect"),
                                      "connect_no", 0,
                                      mView, SLOT( slot_cameraDisconnect() ),
                                      actionCollection(), "cam_disconnect");
    camDisconnectAction->setWhatsThis( i18n("Disconnect from the the Camera") );

    // -------------------------------------------------------------------------

    camDownloadAction = new KActionMenu ( i18n("Download Images"), "filesave",
					  this, "cam_download");
    camDownloadAction->setWhatsThis( i18n("Download Images from the camera") );
    camDownloadAction->setDelayed(false);
    actionCollection()->insert(camDownloadAction);

    camDownloadSelectedAction = new KAction( i18n("Selected"), 0,
					     mView, SLOT(slot_cameraDownload()),
					     actionCollection());
    camDownloadAllAction = new KAction( i18n("All"), 0,
					mView, SLOT(slot_cameraDownloadAll()),
					actionCollection());

    camDownloadAction->insert(camDownloadSelectedAction);
    camDownloadAction->insert(camDownloadAllAction);

    // -------------------------------------------------------------------------

    camDeleteAction = new KActionMenu ( i18n("Delete Images"), "edittrash",
					this, "cam_delete");
    camDeleteAction->setWhatsThis( i18n("Delete Images from the camera") );
    camDeleteAction->setDelayed(false);
    actionCollection()->insert(camDeleteAction);

    camDeleteSelectedAction = new KAction( i18n("Selected"), 0,
					   mView, SLOT(slot_cameraDelete()),
					   actionCollection());
    camDeleteAllAction = new KAction( i18n("All"), 0,
				      mView, SLOT(slot_cameraDeleteAll()),
				      actionCollection());

    camDeleteAction->insert(camDeleteSelectedAction);
    camDeleteAction->insert(camDeleteAllAction);

    // -------------------------------------------------------------------------

    camUploadAction = new KAction(i18n("Upload"), 0,
                                  mView, SLOT(slot_cameraUpload()),
                                  actionCollection(), "cam_upload");
    camUploadAction->setWhatsThis( i18n("Upload Images into Camera"));


    // -------------------------------------------------------------------------

    camCancelAction = new KAction( i18n("Stop"), "stop", 0,
                                   mView, SLOT(slot_cameraCancel()),
                                   actionCollection(), "cam_cancel");
    camCancelAction->setWhatsThis( i18n("Cancel Camera Operations being Performed") );

    // -------------------------------------------------------------------------

    camCameraInfoAction = new KAction( i18n("Information"), 0,
                                       mView, SLOT(slot_cameraInfo()),
                                       actionCollection(), "cam_info");
    camCameraInfoAction->setWhatsThis( i18n("Show Information about the Camera") );

    // -------------------------------------------------------------------------

    appFolderHideAction = new KToggleAction(i18n("Hide Folders"), 0, 0,
                             mView, SLOT( slot_hideFolders() ),
                             actionCollection(), "app_folderhide");
    appCameraFolderHideAction =
        new KToggleAction(i18n("Hide Camera Folders"), 0, 0,
                          mView, SLOT( slot_hideCameraFolders() ),
                          actionCollection(), "app_cameraFolderHide");

    appAlbumFolderHideAction =
        new KToggleAction(i18n("Hide Album Folders"), 0, 0,
                          mView, SLOT( slot_hideAlbumFolders() ),
                          actionCollection(), "app_albumFolderHide");


    (void) new KToggleAction(i18n("Hide StatusBar"), 0, 0,
                             this, SLOT( slot_hideStatusBar() ),
                             actionCollection(), "app_statusbarhide");

    // -------------------------------------------------------------------------

    appSetupAction = new KAction(i18n("Setup"), "configure", 0,
                                      this, SLOT( slot_appSetup() ),
                                      actionCollection(), "app_setup");
    appSetupAction->setWhatsThis( i18n("Configure Digikam") );


    // -------------------------------------------------------------------------

    appThumbSizePlusAction = new KAction(i18n("Increase Thumb Size"),
					 "viewmag+", 0,
					 this, SLOT( slot_thumbSizePlus() ),
					 actionCollection(),
					 "app_thumbsizeIncrease");
    appThumbSizePlusAction->setWhatsThis( i18n("Increase Thumbnail Size"));

    appThumbSizeMinusAction = new KAction(i18n("Decrease Thumb Size"),
					  "viewmag-", 0, this,
					  SLOT( slot_thumbSizeMinus() ),
					  actionCollection(),
					  "app_thumbsizeDecrease");
    appThumbSizeMinusAction->setWhatsThis( i18n("Decrease Thumbnail Size"));

    // -------------------------------------------------------------------------
    appSelectAllAction = new KAction( i18n("All"), 0,
				      mView, SLOT(slot_selectAll()),
				      actionCollection(), "app_selectAll");

    appSelectNoneAction = new KAction( i18n("None"), 0,
				      mView, SLOT(slot_selectNone()),
				      actionCollection(), "app_selectNone");

    appSelectInvertAction = new KAction( i18n("Invert"), 0,
				      mView, SLOT(slot_selectInvert()),
				      actionCollection(), "app_selectInvert");

    // -------------------------------------------------------------------------

    appQuitAction = KStdAction::quit(this, SLOT(slot_exit()),
                                     actionCollection(), "app_exit");
    appQuitAction->setWhatsThis( i18n("Exit Application") );


    // - Set Initial States of Action ------------------------------------------

    camConnectAction->setEnabled(true);
    camDisconnectAction->setEnabled(false);
    camDownloadAction->setEnabled(false);
    camDeleteAction->setEnabled(false);
    camUploadAction->setEnabled(false);
    camCameraInfoAction->setEnabled(false);
    camCancelAction->setEnabled(false);


    switch(mThumbnailSize.getSize()) {

    case(ThumbnailSize::Large): {
        appThumbSizePlusAction->setEnabled(false);
        appThumbSizeMinusAction->setEnabled(true);
        break;
    }

    case(ThumbnailSize::Medium): {
        appThumbSizePlusAction->setEnabled(true);
        appThumbSizeMinusAction->setEnabled(true);
        break;
    }

    case(ThumbnailSize::Small): {
        appThumbSizePlusAction->setEnabled(true);
        appThumbSizeMinusAction->setEnabled(false);
        break;
    }
    }

    // -------------------------------------------------------------------------

    createGUI();
    //createGUI("/home/renchi/Devel/Digikam/Working/digikam3/digikam/digikamui.rc");

}

void Digikam::setupConnections()
{
    connect(mView, SIGNAL(signal_cameraConnected(bool)),
            this, SLOT(slot_cameraConnected(bool)));
    connect(mView, SIGNAL(signal_statusMsg(const QString&)),
            this, SLOT(slot_setStatusMsg(const QString&)));
    connect(mView, SIGNAL(signal_progress(int)),
            this, SLOT(slot_setProgressVal(int)));
    connect(mView, SIGNAL(signal_cameraBusy()),
            this, SLOT(slot_cameraBusy()));
    connect(mView, SIGNAL(signal_cameraIdle()),
            this, SLOT(slot_cameraIdle()));
    connect(mView, SIGNAL(signal_resetStatusBar()),
            this, SLOT(slot_resetStatusBar()));
}

void Digikam::slot_cameraConnected(bool val)
{
    if (val) {
        camConnectAction->setEnabled(false);
        camDisconnectAction->setEnabled(true);
        camDownloadAction->setEnabled(true);
        camDeleteAction->setEnabled(true);
        camUploadAction->setEnabled(true);
        camCameraInfoAction->setEnabled(true);
    }
    else {
        camConnectAction->setEnabled(true);
        camDisconnectAction->setEnabled(false);
        camDownloadAction->setEnabled(false);
        camDeleteAction->setEnabled(false);
        camUploadAction->setEnabled(false);
        camCameraInfoAction->setEnabled(false);
    }
}

void Digikam::slot_resetStatusBar()
{
    mStatusBar->changeItem(mView->getWhatsShowing(), 0);
    mProgressBar->setTotalSteps(100);
    mProgressBar->setProgress(0);
}

void Digikam::slot_hideStatusBar()
{
    if (mStatusBar->isHidden())
        mStatusBar->show();
    else
        mStatusBar->hide();
}

void Digikam::slot_setStatusMsg(const QString& msg)
{
    mStatusBar->changeItem(msg, 0);
}

void Digikam::slot_setProgressVal(int val)
{
    if (val >= 0 && val <= 100) {
        mProgressBar->setProgress(val);
    }
}

void Digikam::slot_cameraBusy()
{
    camCancelAction->setEnabled(true);
}

void Digikam::slot_cameraIdle()
{
    camCancelAction->setEnabled(false);
    slot_resetStatusBar();
}

void Digikam::slot_exit()
{
    close();
}

void Digikam::slot_thumbSizePlus()
{
    switch(mThumbnailSize.getSize()) {

    case(ThumbnailSize::Large): {
        appThumbSizePlusAction->setEnabled(false);
        appThumbSizeMinusAction->setEnabled(true);
        break;
    }

    case(ThumbnailSize::Medium): {
        mThumbnailSize = ThumbnailSize::Large;
        appThumbSizePlusAction->setEnabled(false);
        appThumbSizeMinusAction->setEnabled(true);
        break;
    }

    case(ThumbnailSize::Small): {
        mThumbnailSize = ThumbnailSize::Medium;
        appThumbSizePlusAction->setEnabled(true);
        appThumbSizeMinusAction->setEnabled(true);
        break;
    }

    }

    mView->setThumbnailSize(mThumbnailSize);
}

void Digikam::slot_thumbSizeMinus()
{
    switch(mThumbnailSize.getSize()) {

    case(ThumbnailSize::Large): {
        mThumbnailSize = ThumbnailSize::Medium;
        appThumbSizePlusAction->setEnabled(true);
        appThumbSizeMinusAction->setEnabled(true);
        break;
    }

    case(ThumbnailSize::Medium): {
        mThumbnailSize = ThumbnailSize::Small;
        appThumbSizePlusAction->setEnabled(true);
        appThumbSizeMinusAction->setEnabled(false);
        break;
    }

    case(ThumbnailSize::Small): {
        appThumbSizePlusAction->setEnabled(true);
        appThumbSizeMinusAction->setEnabled(false);
        break;
    }

    }

    mView->setThumbnailSize(mThumbnailSize);
}

void Digikam::slot_appSetup()
{
    Setup *setup = new Setup();
    connect(setup, SIGNAL( finished() ),
            this, SLOT( slot_appSetupFinished() ) );
    connect(setup, SIGNAL( applyClicked() ),
            this, SLOT(slot_appSetupFinished()));
    setup->show();
}

void Digikam::slot_appSetupFinished()
{
    GeneralSettings genSettings;
    genSettings.readSettings();

    CameraSettings camSettings;
    camSettings.readSettings();

    mView->applyGeneralSettings(genSettings);
    mView->applyCameraSettings(camSettings);

    mThumbnailSize.setSize(genSettings.getDefaultIconSize());
    switch(mThumbnailSize.getSize()) {

    case(ThumbnailSize::Large): {
        appThumbSizePlusAction->setEnabled(false);
        appThumbSizeMinusAction->setEnabled(true);
        break;
    }

    case(ThumbnailSize::Medium): {
        appThumbSizePlusAction->setEnabled(true);
        appThumbSizeMinusAction->setEnabled(true);
        break;
    }

    case(ThumbnailSize::Small): {
        appThumbSizePlusAction->setEnabled(true);
        appThumbSizeMinusAction->setEnabled(false);
        break;
    }
    }



}
