#ifndef CAMERAFOLDERITEM_H
#define CAMERAFOLDERITEM_H

#include <qstring.h>
#include <qptrlist.h>
#include <klistview.h>

class CameraFileItem;

class CameraFolderItem : public KListViewItem {

public:

    CameraFolderItem(KListView* _parent,
                     const QString& _name,
                     const QString& _path,
                     bool _root=true);

    CameraFolderItem(KListViewItem* _parent,
                     const QString& _name,
                     const QString& _path,
                     bool _root=false);

    ~CameraFolderItem();

    bool isRoot() const {return mRoot;}
    QString getFolderName() const {return mFolderName;}
    QString getFolderPath() const {return mFolderPath;}

    void setOpen(bool open);
    void incrementNumItems(int val=1);
    void showNumItems();

    bool containsItem(const QString& name);

    void highlight();
    void unHighlight();

    QPtrList<CameraFileItem> fileItemList;

private:

    QString mFolderName;
    QString mFolderPath;
    bool mRoot;
    int mNumItems;

};

#endif
