#include <klocale.h>
#include <klistview.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qheader.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "setup_base.h"


Setup_Base::Setup_Base( QWidget* _parent,  
			    const char* _name)
  : KDialogBase (Tabbed, QString("Digikam Setup"), 
		 Ok|Apply|Cancel, Ok, _parent, _name, 
		 true, true) 
{


  resize( 484, 553 ); 

  cameraPage = addPage ( i18n("Camera Settings") );
  
  cameraPageLayout = new QGridLayout( cameraPage, 1, 1, 5, -1, 
				      "cameraPageLayout"); 
  
  QGroupBox_portSetting = new QGroupBox( cameraPage, "QGroupBox_portSetting" );
  QGroupBox_portSetting->setTitle( i18n( "Port Setting" ) );
  
  QTextLabel_portPath = new QLabel( QGroupBox_portSetting, 
				    "QTextLabel_portPath" );
  QTextLabel_portPath->setGeometry( QRect( 20, 30, 160, 61 ) ); 
  QTextLabel_portPath->setText( i18n( "Set port path for serial\n" 
				      "and parallel ports" ) );

  QComboBox_portPath = new QComboBox( false, QGroupBox_portSetting, 
				      "QComboBox_portPath" );
  QComboBox_portPath->setGeometry( QRect( 20, 100, 161, 31 ) ); 
  QComboBox_portPath->setEditable( true );

  cameraPageLayout->addWidget( QGroupBox_portSetting, 2, 1 );

  QButtonGroup_port = new QButtonGroup( cameraPage, "QButtonGroup_port" );
  QButtonGroup_port->setTitle( i18n( "Port Name" ) );

  QRadioButton_serial = new QRadioButton( QButtonGroup_port, 
					  "QRadioButton_serial" );
  QRadioButton_serial->setGeometry( QRect( 20, 40, 121, 21 ) ); 
  QRadioButton_serial->setText( i18n( "Serial" ) );

  QRadioButton_firewire = new QRadioButton( QButtonGroup_port, 
					    "QRadioButton_firewire" );
  QRadioButton_firewire->setGeometry( QRect( 20, 160, 121, 21 ) ); 
  QRadioButton_firewire->setText( i18n( "FireWire" ) );

  QRadioButton_usb = new QRadioButton( QButtonGroup_port, "QRadioButton_usb" );
  QRadioButton_usb->setGeometry( QRect( 20, 120, 121, 21 ) ); 
  QRadioButton_usb->setText( i18n( "USB" ) );

  QRadioButton_parallel = new QRadioButton( QButtonGroup_port, 
					    "QRadioButton_parallel" );
  QRadioButton_parallel->setGeometry( QRect( 20, 80, 121, 21 ) ); 
  QRadioButton_parallel->setText( i18n( "Parallel" ) );

  cameraPageLayout->addWidget( QButtonGroup_port, 1, 1 );

  QPushButton_autoDetect = new QPushButton( cameraPage, 
					    "QPushButton_autoDetect" );
  QPushButton_autoDetect->setText( i18n( "Auto-Detect" ) );

  cameraPageLayout->addWidget( QPushButton_autoDetect, 0, 1 );

  KListView_cameras = new KListView( cameraPage, "KListView_cameras" );
  KListView_cameras->addColumn( i18n( "Camera Selection" ) );
  KListView_cameras->setAllColumnsShowFocus( true );
  KListView_cameras->setRootIsDecorated( true );

  cameraPageLayout->addMultiCellWidget( KListView_cameras, 0, 2, 0, 0 );


  generalPage = addPage(  i18n("General Settings") );
  generalPageLayout = new QGridLayout( generalPage, 6, 2, 5, -1, 
				       "generalPageLayout"); 
  
  TextLabel = new QLabel( generalPage, "TextLabel" );
  TextLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, 
					 (QSizePolicy::SizeType)0, 
					 0, 0, 
					 TextLabel->sizePolicy().hasHeightForWidth() ) );
  TextLabel->setText( i18n( "Default Download Directory :" ) );
  
  generalPageLayout->addWidget( TextLabel, 0, 0);
  
  QPushButton_browse = new QPushButton( generalPage, "QPushButton_browse" );
  QPushButton_browse->setText( i18n( "Browse" ) );
  
  generalPageLayout->addWidget( QPushButton_browse, 1, 1);
    
  QComboBox_downloadDir = new QComboBox( false, generalPage, 
					 "QComboBox_downloadDir" );
  QComboBox_downloadDir->setEditable( true );
  QComboBox_downloadDir->setAutoCompletion( true );
  QComboBox_downloadDir->setDuplicatesEnabled( false );
  
  generalPageLayout->addWidget( QComboBox_downloadDir, 1, 0);
  
  QCheckBox_connect = new QCheckBox( generalPage, "QCheckBox_connect" );
  QCheckBox_connect->setText( i18n( "Connect to Camera on StartUp" ) );

  generalPageLayout->addWidget( QCheckBox_connect, 2, 0);

  QCheckBox_thumbnails = new QCheckBox( generalPage, "QCheckBox_thumbnails" );
  QCheckBox_thumbnails->setText(i18n("Show ThumbNails On Connect (if Supported)"));

  generalPageLayout->addWidget( QCheckBox_thumbnails, 3, 0);

  QCheckBox_showAllImages = new QCheckBox( generalPage, 
					   "QCheckBox_showAllImages" );
  QCheckBox_showAllImages->setText( i18n( "Show All Images on Connect" ) );

  generalPageLayout->addWidget(QCheckBox_showAllImages, 4, 0);

  QCheckBox_hideCameraFolders = new QCheckBox( generalPage);
  QCheckBox_hideCameraFolders->setText( i18n( "Don't Show Camera Folders" ) );

  generalPageLayout->addWidget( QCheckBox_hideCameraFolders, 5, 0);


  // signals and slots connections
  connect( QPushButton_autoDetect, SIGNAL( clicked() ), 
	   this, SLOT( slot_autoDetect() ) );
  connect( KListView_cameras, SIGNAL( selectionChanged(QListViewItem *) ), 
	   this, SLOT( slot_setModel(QListViewItem *) ) );
  connect( QButtonGroup_port, SIGNAL( clicked(int) ), 
	   this, SLOT( slot_setPortPathLabel(int) ) );
  connect( QPushButton_browse, SIGNAL( clicked() ), 
	   this, SLOT( slot_browse() ) );

  connect( QCheckBox_hideCameraFolders, SIGNAL( toggled(bool) ),
	   this, SLOT( slot_hideCameraFoldersClicked(bool) ) );

  
}

/*  
 *  Destroys the object and frees any allocated resources
 */
Setup_Base::~Setup_Base()
{
    // no need to delete child widgets, Qt does it all for us
}

void Setup_Base::slot_autoDetect()
{
    qWarning( "Setup_Base::slot_autoDetect(): Not implemented yet!" );
}

void Setup_Base::slot_setModel(QListViewItem *)
{
    qWarning( "Setup_Base::slot_setModel(QListViewItem *): Not implemented yet!" );
}

void Setup_Base::slot_setPortPathLabel(int)
{
    qWarning( "Setup_Base::slot_setPortPathLabel(int): Not implemented yet!" );
}

void Setup_Base::slot_browse()
{
    qWarning( "Setup_Base::slot_browse(): Not implemented yet!" );
}

void Setup_Base::slot_hideCameraFoldersClicked(bool on) {
  
  if (on)
    QCheckBox_showAllImages->setChecked(true);
   
}
