#include <qstring.h>

#include "gphoto_status.h"
#include "gphoto_messages.h"

// ------- Gphoto_Status -----------------------------------

float Gphoto_Status::my_target=0.0;
bool  Gphoto_Status::my_cancel=false;

Gphoto_Status::Gphoto_Status () {

  my_context = gp_context_new();

  my_cancel = false;

  gp_context_set_cancel_func  (my_context, cancel_func, NULL);
  gp_context_set_error_func  (my_context, error_func, NULL);
  gp_context_set_status_func (my_context, status_func, NULL);
  gp_context_set_progress_funcs (my_context, progress_start_func,
				 progress_update_func, progress_stop_func,
				 NULL);
}

Gphoto_Status::~Gphoto_Status() {

  if (my_context) {
    gp_context_unref(my_context);
    my_context = NULL;
  }

}

GPContextFeedback Gphoto_Status::cancel_func (GPContext *context, void *data)
{
  return (my_cancel ? GP_CONTEXT_FEEDBACK_CANCEL : GP_CONTEXT_FEEDBACK_OK);
}

void Gphoto_Status::error_func(GPContext *context, const char *format,
			       va_list args, void *data) {

  char buf[4096] = "";
  int nSize = vsnprintf( buf, 4096, format, args );
  if( nSize > 4094 ) nSize = 4094;
  buf[nSize] = '\0';

  QString error;
  error = error.fromLocal8Bit(buf);
  qWarning("Cam Error: " + error);
  Gphoto_Messages::gpMessagesWrapper()->emit errorMessage(error);

}

void Gphoto_Status::status_func (GPContext *context, const char *format,
				 va_list args, void *data) {

  char buf[4096] = "";
  int nSize = vsnprintf( buf, 4096, format, args );
  if( nSize > 4094 ) nSize = 4094;
  buf[nSize] = '\0';

  QString status;
  status = status.fromLocal8Bit(buf);
  Gphoto_Messages::gpMessagesWrapper()->emit statusChanged(status);

}

unsigned int Gphoto_Status::progress_start_func(GPContext *context, float target, const char *format,
					 va_list args, void *data) {
  char buf[4096] = "";
  int nSize = vsnprintf( buf, 4096, format, args );
  if( nSize > 4094 ) nSize = 4094;
  buf[nSize] = '\0';

  QString prog;
  prog = prog.fromLocal8Bit(buf);

  my_target = target;

}

void Gphoto_Status::progress_update_func(GPContext *context, unsigned int id, float current,
					  void *data) {

  int percentage = int(100.0 * current/my_target);
  Gphoto_Messages::gpMessagesWrapper()->emit progressChanged(percentage);
}

void  Gphoto_Status::progress_stop_func(GPContext *context, unsigned int id, void *data) {

  Gphoto_Messages::gpMessagesWrapper()->emit progressChanged(0);
}


