#ifndef DIGIKAM_H
#define DIGIKAM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>

#include <kapp.h>
#include <kmainwindow.h>

#include "digikam_view.h"
#include "thumbnailsize.h"

class KAction;
class KRadioAction;
class KToolBarPopupAction;
class KToggleAction;
class KActionMenu;
class Setup;

class Digikam : public KMainWindow
{
    Q_OBJECT

public:

    Digikam();
    virtual ~Digikam();

private:

  void setupActions();
  void setupConnections();
  void setcamActionsState();
  void loadSettings();

private:

  Digikam_View *m_view;
  QString errorMsg;
  Setup *setup;
  
  QString cameraModel;
  QString cameraPort;
  
  KAction* camConnectAction;
  KAction* camDisconnectAction;  

  KActionMenu* camDownloadAction;
  KAction* camDownloadSelectedAction;
  KAction* camDownloadAllAction;
  
  KActionMenu* camDeleteAction;
  KAction* camDeleteSelectedAction;
  KAction* camDeleteAllAction;
  
  KAction* camCancelAction;

  KAction* camSelectAllAction;
  KAction* camSelectNoneAction;
  KAction* camSelectInvertAction;
 
  
  KAction* camMkFolderAction;
  KAction* camDelFolderAction;
  KAction* camUploadAction;
  
  KAction* camSetupAction;
  KAction* camCameraInfoAction;

  KToggleAction* camFolderHideAction;

  KAction* camThumbSizePlusAction;
  KAction* camThumbSizeMinusAction;

  KAction* appQuitAction;
  KAction* appWhatsThisAction;

  ThumbnailSize::Size m_camThumbSize; 


  // Configuration variables

  KConfig *config;    
  QString config_defaultDownloadDir;
  bool config_showThumbNails;
  bool config_connectStartup;
  bool config_showGlobalFolder;
  bool config_hideCameraFolders;


private slots:

  void slot_camConnect();
  void slot_camDisconnect();
  void slot_camDownload();
  void slot_camDownloadAll();
  void slot_camDelete();
  void slot_camDeleteAll();
  void slot_camCancel();

  void slot_camSelectAll();
  void slot_camSelectNone();
  void slot_camSelectInvert();

  void slot_camStartedProcessing();
  void slot_camStoppedProcessing();
  
  void slot_camConnected();
  
  void slot_camSetup();
  void slot_camSetupFinished();

  void slot_camHideFolders();
  void slot_camHideStatusBar();

  void slot_camThumbSizePlus();
  void slot_camThumbSizeMinus();

  void slot_whatsthis();
  void slot_exit();

};




#endif // DIGIKAM_H
