/***************************************************************************
                          camera_folder.cpp  -  description
                             -------------------
    begin                : Thu Dec 31 12:00:20 CST 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <klistview.h>

#include <qstring.h>
#include <qstring.h>
#include <qwidgetstack.h>

#include "camera_folder.h"
#include "camera_iconview.h"


Camera_Folder::Camera_Folder(KListView* parent, QString folderPath, 
			     QString name): KListViewItem(parent) {
  
  numSubFolders=0;
  numImages=0;

  path = folderPath;
  folderName = name;

  setText(0,folderName);
  setPixmap(0,BarIcon("folder"));

  iconView = NULL;

}

Camera_Folder::Camera_Folder(KListViewItem* parent, QString folderPath,
			     QString name): KListViewItem(parent) {

  numSubFolders=0;
  numImages=0;

  path = folderPath;
  folderName = name;

  setText(0,folderName);
  setPixmap(0,BarIcon("folder"));

  iconView = NULL;
}

Camera_Folder::~Camera_Folder(){

  if (iconView)
    delete iconView;

}

QString Camera_Folder::getPath() {
  return path;
}


void Camera_Folder::setCount(int count) {
  QString numImages;
  setText(0, folderName +  " (" + numImages.setNum(count) + ")" );
}


QString Camera_Folder::getName() {
  return folderName;
}
  

    
void Camera_Folder::setOpen(bool flag) {

  if (flag) 
    setPixmap(0,BarIcon("folder_open"));
  else
    setPixmap(0,BarIcon("folder"));
  QListViewItem::setOpen(flag);

}

void Camera_Folder::setNumSubFolders(int count) {
  numSubFolders=count;
}

void Camera_Folder::setNumImages(int count) {
  numImages=count;
}

int Camera_Folder::getNumSubFolders() {
  return  numSubFolders;
}

int Camera_Folder::getNumImages() {
  return  numImages;
}


