/***************************************************************************
                          Digikam.cpp  -  description
                             -------------------
    begin                : Thu Dec 20 12:40:20 CST 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "digikam.h"

#include <qdir.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qwidgetstack.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qradiobutton.h>

#include <klistview.h>
#include <kiconview.h>
#include <kmessagebox.h>
#include <kcombobox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kstddirs.h>
#include <kiconloader.h>
#include <kaboutdata.h>
#include <kaboutapplication.h>

#include "setup.h"
#include "fileOp.h"
#include "gphoto_messages.h"
#include "camera_folder.h"

#include <iostream.h>


Digikam::Digikam(QWidget *parent, const char *name) : Digikam_MainWindow(parent, name)
{

  initGlobals();

  gpInterface = new Gphoto_Interface();

  initView();

  setAbilitiesButtons();

  setStatusMsg("Ready.");
  
  

}

Digikam::~Digikam()
{

  delete gpInterface;

  delete statusLabel;
  delete progressBar;
  delete statusBar;

}


void Digikam::initGlobals() {

  my_cameraFolder = "/";

  qWarning("Digikam good to go");

}


void Digikam::initView() {
  

  dirBox->insertItem(QDir::currentDirPath(),0);
  dirBox->insertItem(QDir::homeDirPath());  

  KListView_folders->setFullWidth();

  connect(KListView_folders, SIGNAL(executed(QListViewItem *)),
	  this, SLOT(slot_folderViewClicked(QListViewItem *)));

  KIconView_root->setGridX(95);
  KIconView_root->setGridY(95);
  KIconView_root->setAutoArrange(true);
  KIconView_root->setSorting(true);
  KIconView_root->setResizeMode(QIconView::Adjust);
  KIconView_root->setWordWrapIconText(true);
  KIconView_root->setSelectionMode(QIconView::Extended);
  KIconView_root->setItemsMovable(false);


  statusBar = new KStatusBar(this);
  
  statusBar->insertItem ("Ready", 0, 7, false);
  statusBar->setItemAlignment (0, AlignLeft | AlignVCenter);
  QLabel *spacer=new  QLabel(statusBar);
  statusBar->addWidget(spacer, 1, true);  

  connect(Gphoto_Messages::gpMessagesWrapper(), SIGNAL(statusChanged(const QString&)),
	  this, SLOT(slot_setStatusMsg(const QString&)));

  progressBar=new KProgress(statusBar);
  progressBar->setBarStyle(KProgress::Blocked);
  progressBar->setTextEnabled(false);
  statusBar->addWidget( progressBar, 5, true);

  connect(Gphoto_Messages::gpMessagesWrapper(), SIGNAL(progressChanged(int)),
            progressBar, SLOT(setValue(int)));

  Digikam_MainWindowLayout->addWidget(statusBar, 2, 0);



  
}

void Digikam::setAbilitiesButtons() {

  if (!(gpInterface->cameraSupportsThumbNails()))
    QCheckBox_thumbnails->setEnabled(false);
  else
    QCheckBox_thumbnails->setChecked(true);

  if (!(gpInterface->cameraSupportsDelete()))
    QPushButton_delete->setEnabled(false);

  /*  if (!(gpInterface->cameraSupportsMkDir()))
    QPushButton_mkFolder->setEnabled(false);

  if (!(gpInterface->cameraSupportsDelDir()))
  QPushButton_delFolder->setEnabled(false); 

  if (!(gpInterface->cameraSupportsUpload()))
  QPushButton_upload->setEnabled(false); */

  QPushButton_mkFolder->setEnabled(false);
  QPushButton_delFolder->setEnabled(false);
  QPushButton_upload->setEnabled(false);


}

int Digikam::initCamera() {

  int retVal;

  if (!(gpInterface->isCameraInitialised())) {

    setStatusMsg("Initializing camera.");

    retVal = gpInterface->initCamera();

    if (retVal != 0) {
      
      if (retVal == -1) 
	KMessageBox::error(this,"Camera Model or Port Setting\n"
			 "not specified correctly!\n"
			 "Please, run Setup");
      else if (retVal == -2)
	KMessageBox::error(this,"Failed to initialize camera!\n"
			   "Make sure the camera is connected\n"
		       "properly and powered on.");
      else 
	KMessageBox::error(this,"Unknown Error!");      

      return -1;
    }

    setStatusMsg("Camera Initialized");
    
  }

  return 0;

}



int Digikam::getIcons() {

  Camera_Folder *camFolder;
  QStringList imagesList;
  QStringList imagesInfoList;

  imagesList.clear();
  imagesInfoList.clear();

  QListViewItemIterator it(KListView_folders);
  for ( ; it.current(); ++it ) {

    camFolder = (Camera_Folder*) (it.current());
    
    if (gpInterface->getImageNames(camFolder->getPath(), imagesList, imagesInfoList)
	== -1) {
      KMessageBox::error(this, "Failed to get Image Names\n"
			 "Check if camera is disconnected.");
      return -1;
    }

    for (int i=0; i<imagesList.count(); i++) {
      
      if ((imagesInfoList[i]).contains("image") || (imagesInfoList[i]).contains("audio")
	  || (imagesInfoList[i]).contains("video")) {
      
	QIconViewItem* camFolderIconViewItem = new QIconViewItem(camFolder->iconView);

	camFolderIconViewItem->setText(imagesList[i]);
	camFolderIconViewItem->setDropEnabled(false);
	camFolderIconViewItem->setDragEnabled(false);
	camFolderIconViewItem->setPixmap(BarIcon("image", KIcon::SizeLarge));
	if ( QCheckBox_thumbnails->isChecked() && (imagesInfoList[i]).contains("image") )
	  camFolderIconViewItem->setPixmap(gpInterface->getThumbNail(camFolder->getPath(), imagesList[i]));
	else {
	  if ((imagesInfoList[i]).contains("image"))
	    camFolderIconViewItem->setPixmap(BarIcon("image", KIcon::SizeLarge));
	  else if ((imagesInfoList[i]).contains("audio"))
	    camFolderIconViewItem->setPixmap(BarIcon("audio", KIcon::SizeLarge));
	  else if ((imagesInfoList[i]).contains("video"))
	    camFolderIconViewItem->setPixmap(BarIcon("video", KIcon::SizeLarge));
	}
 
      }

    }


    camFolder->setName(imagesList.count());
    

  }

  return 0;

}


int Digikam::getFolderNames(Camera_Folder* camFolder) {
  
  QStringList subFolderList;
  QStringList subFolderNameList;
  int numSubFolders;
  QString folder;
  
  subFolderList.clear();
  subFolderNameList.clear();
  numSubFolders = 0;
  folder = camFolder->getPath();

  if (gpInterface->getSubFolders(folder, subFolderList, 
				 subFolderNameList, numSubFolders) == -1) {
    KMessageBox::error(this, "Failed to get SubFolder names\n"
		       "Check if camera is disconnected.");
    return -1;
  }


  for (int i=0; i<numSubFolders; i++) {

    Camera_Folder *camFolderChild = new Camera_Folder(camFolder, subFolderList[i],
						     subFolderNameList[i]);
    camFolderChild->iconView = new KIconView(QWidgetStack_iconViews);
    camFolderChild->iconView->setMode(KIconView::Select);
    camFolderChild->iconView->setGridX(95);
    camFolderChild->iconView->setGridY(95);
    camFolderChild->iconView->setAutoArrange(true);
    camFolderChild->iconView->setSorting(true);
    camFolderChild->iconView->setResizeMode(QIconView::Adjust);
    camFolderChild->iconView->setWordWrapIconText(true);
    camFolderChild->iconView->setSelectionMode(QIconView::Extended);
    camFolderChild->iconView->setItemsMovable(false);
    QWidgetStack_iconViews->addWidget(camFolderChild->iconView, ++QWidgetStack_id);

    getFolderNames(camFolderChild);
   
  }

  return 0;

}
    


void Digikam::setStatusMsg(const QString &msg) {
  statusBar->changeItem(msg,0);
}


void Digikam::slot_connect()
{

  if (initCamera()!=0)  {
    setStatusMsg("Abort.");	
    return;
  }


  QWidgetStack_id=0;
  QWidgetStack_iconViews->raiseWidget(0);

  KListView_folders->clear();
  Camera_Folder *camFolder = new Camera_Folder(KListView_folders, my_cameraFolder,
					       my_cameraFolder);
  camFolder->iconView = new KIconView(QWidgetStack_iconViews);
  camFolder->iconView->setMode(KIconView::Select);
  camFolder->iconView->setGridX(95);
  camFolder->iconView->setGridY(95);
  camFolder->iconView->setAutoArrange(true);
  camFolder->iconView->setSorting(true);
  camFolder->iconView->setResizeMode(QIconView::Adjust);
  camFolder->iconView->setWordWrapIconText(true);
  camFolder->iconView->setSelectionMode(QIconView::Extended);
  camFolder->iconView->setItemsMovable(false);
  QWidgetStack_iconViews->addWidget(camFolder->iconView, ++QWidgetStack_id);

  if (getFolderNames(camFolder) == -1) {
    setStatusMsg("Abort.");	
    gpInterface->setCameraInitialised(false);
    return;
  }

  
  if (getIcons() == -1) {
    setStatusMsg("Abort.");	
    gpInterface->setCameraInitialised(false);
    return;
  }  

  slot_folderViewClicked(KListView_folders->firstChild()); 
  
}


void Digikam::slot_folderViewClicked(QListViewItem *item) {

  if ( !item )
    return;

  Camera_Folder* cf=(Camera_Folder*)item;
  QWidgetStack_iconViews->raiseWidget(cf->iconView);

  if ((cf->isOpen())) 
    cf->setOpen(false);
  else 
    cf->setOpen(true);

  qWarning(cf->getPath() + " folder clicked");

}


void Digikam::slot_setSelection(int selectMode){

  KIconView* iconView = (KIconView*) QWidgetStack_iconViews->visibleWidget();


  if (selectMode == QButtonGroup_selection->id(QRadioButton_selectAll)) 
    iconView->selectAll(true);
  else if (selectMode == QButtonGroup_selection->id(QRadioButton_selectNone)) 
    iconView->selectAll(false);
  else if (selectMode == QButtonGroup_selection->id(QRadioButton_selectInverse))
    iconView->invertSelection();

}



void Digikam::slot_browse() {
  
  QString result = 
    KFileDialog::getExistingDirectory( dirBox->text(dirBox->currentItem()),
				       this );
  if (!result.isEmpty()) {
    for (int i = 0; i < dirBox->count(); i++)
      if (result == dirBox->text(i)) {
	dirBox->setCurrentItem(i);
	return;
      }
    dirBox->insertItem(result, 0);
    dirBox->setCurrentItem(0);
  }
  
}


void Digikam::slot_setup()
{
	Setup *setup=new Setup();
	setup->exec();
	gpInterface->setCameraInitialised(false);
	setAbilitiesButtons();
}


void Digikam:: slot_downloadImages() 
{
  KIconView* iconView = (KIconView*) QWidgetStack_iconViews->visibleWidget();
  Camera_Folder *camFolder = (Camera_Folder*) KListView_folders->firstChild();

  while (camFolder) {
    
    if (camFolder->iconView == iconView) 
      break;
    camFolder = (Camera_Folder*) camFolder->itemBelow();
  }

  if (camFolder==NULL) return;

  qWarning("Downloading from: " + camFolder->getPath());


  int j = 0;
  for ( QIconViewItem *i = iconView->firstItem(); i; i = i->nextItem() )
    if (i->isSelected()) ++j;
  if (j == 0) {
    KMessageBox::error(this,"No images selected!");
    return;
  }


  QString saveFile;
  QString saveDir=dirBox->currentText();
  QDir dir(saveDir);
  bool overwriteallmode=false;
  bool skipallmode=false;
  bool savefilemode=true;

  if (!dir.exists()) {
    KMessageBox::error(this, saveDir + " does not exit!");
    return;
  }

  setStatusMsg("Starting Downloads ...");

  for ( QIconViewItem *i = iconView->firstItem(); i; i = i->nextItem() ) {

    if (skipallmode) break;

    if (i->isSelected()) {

      saveFile=saveDir + "/" + i->text();
      qWarning(saveFile);


      while (QFile::exists(saveFile) && !(overwriteallmode)) {

	FileOpDialog *dlg = new FileOpDialog(saveFile, saveFile, NULL, NULL);

	if (dlg->exec()== QDialog::Rejected){
	  setStatusMsg("Abort.");
	  delete dlg;
	  return;
	}

	if (dlg->fileOpSelection() == Skip) {
	  qWarning("Skipped.");
	  delete dlg;
	  savefilemode=false;
	  break;
	} 
	else if (dlg->fileOpSelection() == SkipAll) {
	  qWarning("Skipped All.");
	  skipallmode=true;
	  savefilemode=false;
	  delete dlg;
	  break;
	} 
	else if (dlg->fileOpSelection() == Overwrite) {
	  qWarning("Overwrite.");	  
	  delete dlg;
	  savefilemode=true;
	  break;
	}
	else if (dlg->fileOpSelection() == OverwriteAll) {
	  qWarning("Overwrite All.");	  
	  delete dlg;
	  savefilemode=true;
	  overwriteallmode=true;
	  break; 
	}
	else if (dlg->fileOpSelection() == Rename) {
	  qWarning("Rename.");
	  savefilemode=true;
	  saveFile = saveDir+"/"+dlg->renameString();
	  delete dlg;
	  qWarning(saveFile+" - New Name");
	}

      }

      if (savefilemode) {
	if ((gpInterface->downloadImage(camFolder->getPath(), 
					i->text(), saveFile)) < 0) {
	  KMessageBox::error(this,"Failed to save images!");
	  return;
	}
      }
      savefilemode=true;
      iconView->arrangeItemsInGrid();
    }

  }
  
  progressBar->setValue(0);
  setStatusMsg("Finished Downloads");

}

void Digikam::slot_deleteImages()
{
  KIconView* iconView = (KIconView*) QWidgetStack_iconViews->visibleWidget();
  Camera_Folder *camFolder = (Camera_Folder*) KListView_folders->firstChild();

  while (camFolder) {
    
    if (camFolder->iconView == iconView) 
      break;
    camFolder = (Camera_Folder*) camFolder->itemBelow();
  }

  if (camFolder==NULL) return;
  
  qWarning("Deleting from: " + camFolder->getPath());

  int j = 0;
  for ( QIconViewItem *i = iconView->firstItem(); i; i = i->nextItem() )
    if (i->isSelected()) ++j;
  if (j == 0) {
    KMessageBox::error(this,"No images selected!");
    return;
  }

  if (KMessageBox::warningYesNo(this,"About to delete Image(s)\n"
				"Are you sure?")==KMessageBox::Yes) {

    QIconViewItem *i = iconView->firstItem();
    while (i) {
      
      QIconViewItem *nextIconViewItem = i->nextItem();

      if (i->isSelected()) {
	if (gpInterface->deleteImage(camFolder->getPath(), i->text()) < 0) {
	  KMessageBox::error(this,"Failed to delete images!");
	  return;
	}
	delete i;
	iconView->arrangeItemsInGrid();
      }

      i = nextIconViewItem;

      
    }
    
    camFolder->setName(iconView->count());

  }

}


void Digikam::slot_close() 
{
  close();
}



void Digikam::slot_setStatusMsg(const QString &msg) {
  statusBar->message(msg,2000);
}

void Digikam::slot_about() {

  /*  KAboutDialog aboutDialog;
  aboutDialog.setAuthor("Renchi Raju", "renchi@green.tam.uiuc.edu",
			"http://digikam.sourceforge.net", NULL);
  aboutDialog.setLogo(BarIcon("kde", KIcon::SizeLarge));
  aboutDialog.show();
  */

  const KAboutData *aboutData = KGlobal::instance()->aboutData();
  
  KAboutApplication about(aboutData);
  about.show();


}
