/* Copyright (C) 2002 Philippe Fremy <pfremy@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <kiconloader.h>
#include <kstddirs.h>
#include <kapp.h>
#include <kaction.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kcmdlineargs.h>
#include <klibloader.h>
#include <kuserprofile.h>
#include <qwidget.h>
#include <qdir.h>
#include <kdebug.h>

#include <ktrader.h>

#include "vimpart_shell.h"

VimPartShell::VimPartShell()
{
  new KAction( "&Open file" , "fileopen", 0, this,
    SLOT( slotFileOpen() ), actionCollection(), "file_open" );

  new KAction( "&Quit" , "exit", 0, this, SLOT( close() ), actionCollection(), "file_quit" );

  new KAction( "&Hop" , 0, actionCollection(),
          "edit_hop" );


  kdDebug() << "Action count " << actionCollection()->count() << endl;


  setXMLFile( "vimPartShell.rc" );

  QString partClassName;
  partClassName = "KParts/ReadOnlyPart";
  partClassName = "KParts/ReadWritePart";

  KTrader::OfferList offers = KTrader::self()->query(
          "text/x-c++hdr", 
          "('" + partClassName + "' in ServiceTypes)"
          );

  KLibFactory *factory = 0;
  _vimpart = 0;
  kdDebug() << "Number of offers : " << offers.count() << endl;
  KTrader::OfferList::Iterator it(offers.begin());
  for( ; it != offers.end(); ++it)
  {
    KService::Ptr ptr = (*it);
    //kdDebug() << "Name : "  << ptr->name() << endl;
    kdDebug() << "Library : " <<  ptr->library() << endl;
    //kdDebug() << "Preference : " <<  ptr->initialPreference() << endl;
    //kdDebug() << ".desktop path : " <<  ptr->desktopEntryPath() << endl;
  }

  for( it = offers.begin(); it != offers.end(); ++it)
  {
    KService::Ptr ptr = (*it);

    factory = KLibLoader::self()->factory( ptr->library().latin1() );
    if (factory)
    {
        kdDebug() << "Using " << ptr->library() << endl;
      _vimpart = static_cast<KParts::ReadWritePart *>(factory->create(this, ptr->name().latin1(), "KParts::ReadWritePart" ));
      setCentralWidget( _vimpart->widget() );
      // Integrate its GUI
      createGUI( _vimpart );
	  _vimpart->widget()->resize( _vimpart->widget()->size() );

      /*
      kdDebug() << "Local xml file : " << localXMLFile() << endl;
      kdDebug() << "xml file : " << xmlFile() << endl;
      */


      break;
    }
  }

  // if we couldn't find a component with the trader, try the
  // kghostview library directly.  if this ever happens, then something
  // is seriously screwed up, though -- the kghostview component
  // should be picked up by the trader
  if (!_vimpart)
  {
    factory = KLibLoader::self()->factory( "libvimpart" );
    if (factory)
    {
      // Create the part
      _vimpart = (KParts::ReadWritePart *)factory->create( this, "vimpart",
                 "KParts::ReadWritePart" );
      // Set the main widget
      setCentralWidget( _vimpart->widget() );
      // Integrate its GUI
      createGUI( _vimpart );
	  _vimpart->widget()->resize( _vimpart->widget()->size() );

    }
    else
    {
       KMessageBox::error(this, "No libvimpart found !");
    }
  }
  // Set a reasonable size
  resize( 600, 350 );

  openURL( "file:TODO" );
}

VimPartShell::~VimPartShell()
{
  delete _vimpart;
}

void VimPartShell::openURL( const KURL & url )
{
  _vimpart->openURL( url );
}

void VimPartShell::slotFileOpen()
{
  KURL url = KFileDialog::getOpenURL( QString::null, "*.*", 0L, "file dialog" );

  if( !url.isEmpty() )
     openURL( url );
}

static KCmdLineOptions options[] =
{
 { "+file(s)",          "Files to load", 0 },
 { 0,0,0 }
};
static const char *version = "v0.1 2001 (c) Philippe Fremy";
static const char *description = "Test Shell for the vim kpart.";

int main( int argc, char **argv )
{
  KCmdLineArgs::init(argc, argv, "vimpartshell", description, version);
  KCmdLineArgs::addCmdLineOptions( options ); // Add my own options.
  KApplication app;
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  VimPartShell *shell = new VimPartShell;
  if ( args->count() == 1 )
  {
    // Allow full paths, but also simple filenames from current dir
    KURL url( QDir::currentDirPath()+"/", args->arg(0) );
    shell->openURL( url );
  }
  shell->show();
  return app.exec();
}
