/* vi:set ts=8 sts=0 sw=8:
 *
 * VIM - Vi IMproved		by Bram Moolenaar
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

/*
 * Porting to KDE(2) was done by
 *
 *  (C) 2000 by Thomas Capricelli <orzel@kde.org>
 *
 *  Please visit http://klotski.berlios.de/kvim for other vim- or
 *  kde-related coding.
 *
 *  $Id: gui_kde_widget.h,v 1.9 2002/04/02 06:40:34 marchand Exp $
 *
 */

#ifndef GUI_KDE_WIDGET
#define GUI_KDE_WIDGET


#if 1
#define dbf( format, args... ) { printf( "%s" " : " format "\n" , __FUNCTION__ , ## args ); fflush(stdout); }
#define db()       { printf( "%s\n", __FUNCTION__ );fflush(stdout); }
#else
#define dbf(format, args... )
#define db()
#endif
                                                                              


#define UNIX	    // prevent a warning : a symbol is defined twice in X and Qt

#include <qdialog.h>
#include <qlabel.h>
#include <qsignalmapper.h>
#include <qtimer.h>
#include <qevent.h>
#include <qlineedit.h>

#include <klocale.h>
#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h> 
#if (KDE_VERSION>=290)
#include <kmainwindow.h>
#include <keditcl.h>
#else
#include <ktmainwindow.h>
#include <keditcl.h>
#endif
#include <kparts/part.h>
#include <kurl.h>
#undef UNIX	    // prevent a warning
#include "kvim_iface.h"

extern "C" {
#include "vim.h"
}

class QPushButton;

class	VimFrame : public QFrame
{
public:
	VimFrame( QWidget *parent=0, const char *name=0, WFlags f=0 ) : QFrame(parent,name,f) { setMouseTracking(true); }

	virtual void paintEvent( QPaintEvent *);
	void	draw_string(int x, int y, QString s, int len, int flags);

protected:
	virtual void mousePressEvent( QMouseEvent *);
	virtual void mouseDoubleClickEvent( QMouseEvent *);
	virtual void mouseReleaseEvent( QMouseEvent *);
	virtual void mouseMoveEvent( QMouseEvent *);
	virtual void wheelEvent (QWheelEvent *);

};


enum BlinkState {
	BLINK_NONE,
	BLINK_ON,
	BLINK_OFF
};


class VimWidget : public QWidget, virtual public KVim
{
	Q_OBJECT

public:
	VimWidget( QWidget *parent=0, const char *name=0, WFlags f=0 );

	/** public, so that gui_mch_* functions can access it */
	VimFrame	drawing_area;

	/** Init the blinking time */
	void set_blink_time( long, long, long );
	void start_cursor_blinking();
	void stop_cursor_blinking();
	void wait(long);
	void serverActivate();

	void flash();
	
	/** DCOP */
	void exec(QString command);
	
	QColor	fg_color;
	QColor	bg_color;
	bool wait_done;

protected:
	virtual void resizeEvent ( QResizeEvent *e );
	virtual void keyPressEvent( QKeyEvent * );
	virtual void focusInEvent( QFocusEvent * );
	virtual void focusOutEvent( QFocusEvent * );
	virtual void dragEnterEvent (QDragEnterEvent *);
	virtual void dropEvent (QDropEvent *);

	/* cursor blinking stuff */
	QTimer blink_timer;
	long blink_wait_time, blink_on_time, blink_off_time;
	BlinkState blink_state;

	/* wait for input */
	QTimer	wait_timer;

public slots:
	void    blink_cursor();
	void	wait_timeout();

};


class VimMainWindow : public KMainWindow
{
	Q_OBJECT

public:
	VimMainWindow ( const char *name = 0L, WFlags f = WDestructiveClose );

	/** called when the widget closes */
	bool close(bool alsoDelete);

	VimWidget	*w;
        KEdFind         *finddlg;
	KEdReplace	*repldlg;
	int		have_tearoff;
protected:

public slots:
	void    menu_activated(int dx);
	void 	clipboard_update();
        void    slotSearch();
        void    slotFind();
        void    slotReplace();
        void    slotReplaceAll();

};


class VimDialog : public QDialog
{

public:
	VimDialog (int type,		/* type of dialog */
	       unsigned char * title,		/* title of dialog */
	       unsigned char * message,	/* message text */
	       unsigned char * buttons,	/* names of buttons */
	       int def_but,		/* default button */
	       char_u *textfield);		/* input text */
private:
	QSignalMapper	mapper;
	QLineEdit	*entry;
	char_u		*ret;
	int		butNb;

protected:
	void reject() { done(0); }
	void accept() 
	{
	       	if (result() == QDialog::Accepted) {
			STRCPY(ret, (const char*) entry->text());
			dbf("%s",ret);
		}
		else *ret = NUL;
		done( result() ); 
	}
};


/*
 * QScrollBar  pool
 */
struct GuiScrollbar;

class SBPool : public QObject
{
	Q_OBJECT
public:
	SBPool(void);
	void create(GuiScrollbar * sb, int orient);
	void destroy(GuiScrollbar * sb);
public slots:
	void sbUsed(int who);
private:
	QSignalMapper mapper;
};

extern VimMainWindow	*vmw;
extern SBPool		*sbpool;


#endif // GUI_KDE_WIDGET
