#ifndef __MAINWIDGET_H
#define __MAINWIDGET_H

#include <qobject.h>
#include <qwidget.h>
#include <qlabel.h>
#include <kcombobox.h>
#include <klineedit.h>

class MainWidget : public QWidget
{
Q_OBJECT

public:
	MainWidget(QWidget* parent);

private slots:
	void slotConvertJewishToGregorian();
	void slotCopyJewishToGregorian();
	void slotConvertGregorianToJewish();
	void slotCopyGregorianToJewish();
	void slotCopyCurrentJewishDate();
	void slotClose();
	void slotAbout();

private:
	QString getGregorianMonthName(int month);
	QString getJewishMonthName(int month);

	void copyStringIntoClipboard(QString str);
	
	QClipboard* m_clipboard;

	KComboBox* m_comboboxJewishToGregorianJewishDay;
	KComboBox* m_comboboxJewishToGregorianJewishMonth;
	KLineEdit* m_lineeditJewishToGregorianJewishYear;
	QLabel* m_labelJewishToGregorianGregorian;

	KComboBox* m_comboboxGregorianToJewishGregorianDay;
	KComboBox* m_comboboxGregorianToJewishGregorianMonth;
	KLineEdit* m_lineeditGregorianToJewishGregorianYear;
	QLabel* m_labelGregorianToJewishJewish;
};

#endif

