/***************************************************************************
                                dateRange.cpp
                             -------------------
    begin                : Sept 24, 2009
    copyright            : (C) 2009 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <qdatetime.h>
#include <qstring.h>
#include <fitsio.h>

void usage() {
  fprintf(stderr, "usage: planckDateRange in_filename\n");
}

static void exitHelper() {
}

void convertToDate(double value, char* date, size_t len) {

  QDateTime dateTime;
  int iNumDays;
  int iNumSeconds;

  dateTime.setDate( QDate(1958, 1, 1) );
  dateTime.setTime( QTime( 0, 0, 0 ) );

  //
  // convert from 2^-16 seconds to seconds...
  //

  value /= 65536.0;

  iNumDays = (int)floor(value / (60.0 * 60.0 * 24.0));
  iNumSeconds = (int)floor(value + 0.5) - (iNumDays * (60 * 60 * 24));

  dateTime = dateTime.addDays( iNumDays );
  dateTime = dateTime.addSecs( iNumSeconds );

  strncpy( date, dateTime.toString("yyyyMMddhhmmss").latin1(), len );
  date[len] = '\0';
}

void displayTimes(double valueLo, double valueHi) {
  char dateLo[] = {"YYYYMMDDHHMMSS"};
  char dateHi[] = {"YYYYMMDDHHMMSS"};

  convertToDate(valueLo, dateLo, strlen(dateLo));
  convertToDate(valueHi, dateHi, strlen(dateHi));

  printf("%s %s\n", dateLo, dateHi);
}

bool readNonOBTValues(fitsfile* ffits, double& valueLo, double& valueHi) {
  char comment[FLEN_COMMENT];
  double valueDelta;
  bool bRetVal = false;
  int iStatus = 0;

  if (fits_read_key_dbl( ffits, "TIMEZERO", &valueLo, comment, &iStatus ) == 0) {
    if (fits_read_key_dbl( ffits, "DELTA_T", &valueDelta, comment, &iStatus ) == 0) {

      long lNumRows;

      if (fits_get_num_rows( ffits, &lNumRows, &iStatus ) == 0) {

        valueHi = valueLo + ((double)lNumRows * valueDelta);

        bRetVal = true;
      }
    }
  }

  return bRetVal;
}

bool readOBTValues(fitsfile* ffits, double& valueLo, double& valueHi) {
  char value[FLEN_VALUE];
  char comment[FLEN_COMMENT];
  bool bRetVal = false;
  int iStatus = 0;

  if (fits_read_keyword( ffits, "TIMEZERO", value, comment, &iStatus ) == 0) {

    int iNumCols;

    if (fits_get_num_cols( ffits, &iNumCols, &iStatus ) == 0 ) {

      long lNumRows;

      if (fits_get_num_rows( ffits, &lNumRows, &iStatus ) == 0 ) {

        if (iNumCols == 1) {

          double nan = strtod( "nan", NULL );
          int iAnyNull = 0;

          fits_read_col( ffits, TDOUBLE, 1, 1, 1, 1, &nan, &valueLo, &iAnyNull, &iStatus );
          fits_read_col( ffits, TDOUBLE, 1, lNumRows, 1, 1, &nan, &valueHi, &iAnyNull, &iStatus );

          if( iStatus == 0) {
            bRetVal = true;
          }
        }
      }
    }
  }

  return bRetVal;
}

bool extractDateRange(const char* filename) {
  fitsfile* ffits;
  bool bRetVal = false;
  int iStatus = 0;

  if (fits_open_file( &ffits, filename, READONLY, &iStatus ) == 0) {

    int iNumHeaderDataUnits;

    if (fits_get_num_hdus( ffits, &iNumHeaderDataUnits, &iStatus ) == 0) {
      if (iNumHeaderDataUnits > 1) {

        char value[FLEN_VALUE];
        int iHDUType;

        if (fits_movabs_hdu( ffits, 2, &iHDUType, &iStatus ) == 0) {
          if (fits_read_btblhdr( ffits, 0, 0L, 0L, 0L, 0L, 0L, value, 0L, &iStatus ) == 0 ) {

            double valueLo;
            double valueHi;
            bool bContinue = false;

            if (strcmp(value, "OBT") == 0) {
              bContinue = readOBTValues(ffits, valueLo, valueHi);
            } else {
              bContinue = readNonOBTValues(ffits, valueLo, valueHi);
            }

            if (bContinue) {
              if (valueHi > valueLo) {
                displayTimes(valueLo, valueHi);

                bRetVal = true;
              }
            }
          }
        }
      }
    }

    iStatus = 0;

    fits_close_file( ffits, &iStatus );
  }

  return bRetVal;
}

int main(int argc, char *argv[]) {
  int iRetVal = 0;

  atexit(exitHelper);

  if (argc ==  2) {
    if (!extractDateRange(argv[1])) {
      iRetVal = -1;
    }
  } else {
    usage();

    iRetVal = -1;
  }

  return iRetVal;
}
