/***************************************************************************
                     kstgraphdialog_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2003 The University of Toronto
                           (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtimer.h>

// include files for KDE
#include <kconfig.h>
#include <kdebug.h>
#include <kimageio.h>
#include <kurlcompletion.h>
#include <kurlrequester.h>

// application specific includes
#include "kstgraphfiledialog_i.h"


KstGraphFileDialogI::KstGraphFileDialogI(QWidget* parent, const char* name,
                                         bool modal, WFlags fl)
: KstGraphFileDialog(parent, name, modal, fl) {
  _autoSaveTimer = new QTimer(this);

  connect(_close,         SIGNAL(clicked()),         this, SLOT(saveProperties()));
  connect(_square,        SIGNAL(clicked()),         this, SLOT(square()));
  connect(_save,          SIGNAL(clicked()),         this, SLOT(reqGraphFile()));
  connect(_autosave,      SIGNAL(toggled(bool)),     this, SLOT(setAutoSave()));
  connect(_period,        SIGNAL(valueChanged(int)), this, SLOT(setAutoSave()));
  connect(_autoSaveTimer, SIGNAL(timeout()),         this, SLOT(reqGraphFile()));
  connect(_xSize,         SIGNAL(valueChanged(int)), this, SLOT(xsizeChanged(int)));

  _url->setFilter(KImageIO::mimeTypes().join(" "));
  _url->setMode(KFile::File);

  _comboBoxFormats->insertStrList(QImageIO::outputFormats());
  _comboBoxFormats->setCurrentItem(0);

  loadProperties();

  square();
  setAutoSave();
}


KstGraphFileDialogI::~KstGraphFileDialogI() {
}


void  KstGraphFileDialogI::showGraphFileDialog() {
  show();
  raise();
}


void KstGraphFileDialogI::square() {
  xsizeChanged(_xSize->value());
  if (_square->isChecked()) {
    _ySize->setEnabled(false);
  } else {
    _ySize->setEnabled(true);
  }
}


void KstGraphFileDialogI::xsizeChanged(int x) {
  if (_square->isChecked()) {
    _ySize->setValue(x);
  }
}


void KstGraphFileDialogI::reqGraphFile() {
  emit graphFileReq(_url->url(), _comboBoxFormats->currentText(), _xSize->value(), _ySize->value(), _radioButtonAll->isChecked());
}


void KstGraphFileDialogI::setAutoSave() {
  if (_autosave->isChecked()) {
    _autoSavePeriodLabel->setEnabled(true);
    _period->setEnabled(true);
    _autoSaveTimer->start(_period->value()*1000, false);
  } else {
    _autoSavePeriodLabel->setEnabled(false);
    _period->setEnabled(false);
    _autoSaveTimer->stop();
  }
}


bool KstGraphFileDialogI::autoSaving() const {
  return _autoSaveTimer->isActive();
}


int KstGraphFileDialogI::autoSaveTimer() const {
  return _period->value();
}


void KstGraphFileDialogI::setAutoSaveTimer(int time) {
  _period->setValue(time);
  if (autoSaving()) {
    _autoSaveTimer->start(_period->value()*1000, false);
  }
}


void KstGraphFileDialogI::setAutoSave(bool on) {
  _autosave->setChecked(on);
  if (on) {
    _autoSaveTimer->start(_period->value()*1000, false);
  } else {
    _autoSaveTimer->stop();
  }
}


KURL KstGraphFileDialogI::url() const {
  return _url->url();
} 


void KstGraphFileDialogI::setURL(const QString& url) {
  QString path;

  if (url.isEmpty()) {
    path = QDir::currentDirPath();
  } else {
    path = url;
  }
  _url->setURL(path);
  _url->completionObject()->setDir(path);
} 


QString KstGraphFileDialogI::format() const {
  return _comboBoxFormats->currentText();
}


void KstGraphFileDialogI::setFormat(const QString& fmt) {
  QString upfmt = fmt.upper();
  for (int i = 0; i < _comboBoxFormats->count(); i++) {
    const QString& str = _comboBoxFormats->text(i);
    if (str.upper() == fmt) {
      _comboBoxFormats->setCurrentItem(i);
      break;
    }
  }
}


bool KstGraphFileDialogI::isSquare() const {
  return _square->isChecked();
}


void KstGraphFileDialogI::setSquare(bool on) {
  _square->setChecked(on);
  if (on) {
    square();
  } else {
    _ySize->setEnabled(true);
  }
}


int KstGraphFileDialogI::imageXSize() const {
  return _xSize->value();
}


int KstGraphFileDialogI::imageYSize() const {
  return _ySize->value();
}


void KstGraphFileDialogI::setImageSize(int sizeX, int sizeY) {
  _xSize->setValue(sizeX);
  xsizeChanged(sizeX);
  if(!_square->isChecked()) {
    _ySize->setValue(sizeY);
  }
}


void KstGraphFileDialogI::saveProperties() {
  KConfig cfg("kstautosaverc", false, false);

  cfg.setGroup("AutoSaveImages");

  cfg.writeEntry("AutoSave", _autosave->isChecked());
  cfg.writeEntry("Seconds", _period->value());
  cfg.writeEntry("Location", _url->url());

  cfg.writeEntry("XSize", _xSize->value());
  cfg.writeEntry("YSize", _ySize->value());
  cfg.writeEntry("Square", _square->isChecked());

  cfg.writeEntry("All", _radioButtonAll->isChecked());
  cfg.writeEntry("Format", _comboBoxFormats->currentText());

  cfg.sync();
}


void KstGraphFileDialogI::loadProperties() {
  KConfig cfg("kstautosaverc");
  QString path;
  bool bSquare;
  bool all;

  cfg.setGroup("AutoSaveImages");

  _autosave->setChecked(false);
  _period->setValue(cfg.readNumEntry("Seconds", 15));
  path = cfg.readEntry("Location", "");
  setURL(path);

  _xSize->setValue(cfg.readNumEntry("XSize", 640));
  _ySize->setValue(cfg.readNumEntry("YSize", 480));
  bSquare = cfg.readBoolEntry("Square", false);
  if (bSquare) {
    _square->setChecked(true);
  } else {
    _square->setChecked(false);
  }

  all = cfg.readBoolEntry("All", false);
  if (all) {
    _radioButtonAll->setChecked(true);
    _radioButtonActive->setChecked(false);
  } else {
    _radioButtonAll->setChecked(false);
    _radioButtonActive->setChecked(true);
  }
  setFormat(cfg.readEntry("Format", "PNG"));
}

#include "kstgraphfiledialog_i.moc"
// vim: ts=2 sw=2 et
