/**************************************************************************
              kstdebugdialog_i.cpp - debug dialog: inherits designer dialog
                             -------------------
    begin                :  2004
    copyright            : (C) 2004 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistview.h>

// include files for KDE
#include <kcolorbutton.h>
#include <kdebug.h>
#include <klocale.h>

#include "kstdatacollection.h"
#include "kstdebugdialog_i.h"
#include "kstlogtable.h"
#include "kstversion.h"

/*
 *  Constructs a KstDebugDialogI which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KstDebugDialogI::KstDebugDialogI(QWidget* parent,
                               const char* name, bool modal, WFlags fl)
: DebugDialog(parent, name, modal, fl ) {
  _table = new KstLogTable( TabPage, "_table" );
  _table->setDebug(KstDebug::self());
  
  TabPageLayout->addMultiCellWidget(_table, 0, 0, 0, 2);
 
  const QStringList& pl = KstDataSource::pluginList();
  
  for (QStringList::ConstIterator it = pl.begin(); it != pl.end(); ++it) {
    new QListViewItem(_dataSources, *it);
  }
  
  _buildInfo->setText(i18n("<h1>Kst</h1> version %1").arg(KSTVERSION));
    
  if (_table->numCols() != 3) {  
    for (int i = 0; i < _table->numCols(); ) {
      _table->removeColumn(0);
    }
    _table->insertColumns(0, 3);
  }
  
  QStringList	labels;
  labels.append(" ");
  labels.append(i18n("Date"));
  labels.append(i18n("Message"));
  _table->setColumnLabels(labels);
  _table->setReadOnly(true);
  _table->setRowMovingEnabled(false);
  
  connect(KstDebug::self(), SIGNAL(logAdded()), this, SLOT(logAdded()));
  connect(_email, SIGNAL(clicked()), this, SLOT(email()));
  connect(_clear, SIGNAL(clicked()), this, SLOT(clear()));
  connect(checkBoxShowDebug,   SIGNAL(clicked()), this, SLOT(messagesDebug()));
  connect(checkBoxShowWarning, SIGNAL(clicked()), this, SLOT(messagesWarning()));
  connect(checkBoxShowOther,   SIGNAL(clicked()), this, SLOT(messagesOther()));
  connect(checkBoxShowNotice,  SIGNAL(clicked()), this, SLOT(messagesNotice()));
  connect(checkBoxShowError,   SIGNAL(clicked()), this, SLOT(messagesError()));
  
  _firstNotification = true;
}

KstDebugDialogI::~KstDebugDialogI() {
}

void KstDebugDialogI::show_I() {   
  // Inefficient but shouldn't be a factor
  QListViewItemIterator it(_dataSources);
  KST::dataSourceList.lock().readLock();
  while (it.current()) {
    while (it.current()->childCount() > 0) {
      delete it.current()->firstChild();
    }

    for (KstDataSourceList::Iterator i = KST::dataSourceList.begin(); i != KST::dataSourceList.end(); ++i) {
      (*i)->readLock();
      if ((*i)->sourceName() == it.current()->text(0)) {
        new QListViewItem(it.current(), QString::null, (*i)->fileName());
      }
      (*i)->readUnlock();
    }
    ++it;
  }
  KST::dataSourceList.lock().readUnlock();
  
  update();
  
  QDialog::show();
}

void KstDebugDialogI::logAdded() {
  update();

  _table->setMoveToLast();
  
  if (_firstNotification) {
    QRect rect = _table->horizontalHeader()->rect();
    _table->setColumnWidth(0,  3*rect.width()/20);
    _table->setColumnWidth(1,  5*rect.width()/20);
    _table->setColumnWidth(2, 12*rect.width()/20);
    
    _firstNotification = false;
  }
}

void KstDebugDialogI::messagesDebug() {
  _table->hideRows(KstDebug::Debug, !checkBoxShowDebug->isChecked(), 0);
}

void KstDebugDialogI::messagesWarning() {
  _table->hideRows(KstDebug::Warning, !checkBoxShowWarning->isChecked(), 0);
}

void KstDebugDialogI::messagesNotice() {
  _table->hideRows(KstDebug::Notice, !checkBoxShowNotice->isChecked(), 0);
}

void KstDebugDialogI::messagesOther() {
  _table->hideRows(KstDebug::None, !checkBoxShowOther->isChecked(), 0);
}

void KstDebugDialogI::messagesError() {
  _table->hideRows(KstDebug::Error, !checkBoxShowError->isChecked(), 0);
}

void KstDebugDialogI::clear() {
  KstDebug::self()->clear();
  _table->clear();
}

void KstDebugDialogI::email() {
  KstDebug::self()->sendEmail();
}

#include "kstdebugdialog_i.moc"
// vim: et ts=2 sw=2
