/***************************************************************************
                       kstvectordialog_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2003 The University of Toronto
                           (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>

#include <qwidget.h>
#include <qstring.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qtoolbutton.h>

#include <klocale.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kurlrequester.h>
#include <kstaticdeleter.h>
#include <kcombobox.h>

#include "kstvectordialog_i.h"
#include "datarangewidget.h"
#include "kstrvector.h"
#include "kstdoc.h"
#include "kstdatacollection.h"
#include "kstvectordefaults.h"

#define DIALOGTYPE KstVectorDialogI
#define DTYPE "Vector"
#include "dataobjectdialog.h"

KstVectorDialogI *KstVectorDialogI::_inst = 0L;
static KStaticDeleter<KstVectorDialogI> _vInst;

KstVectorDialogI *KstVectorDialogI::globalInstance() {
  if (!_inst) {
    _inst = _vInst.setObject(new KstVectorDialogI);
  }
return _inst;
}

KstVectorDialogI::KstVectorDialogI(QWidget* parent, const char* name,
                                   bool modal, WFlags fl)
: KstVectorDialog(parent, name, modal, fl) {
  Init();

  FileName->setMode(KFile::File | KFile::Directory | KFile::ExistingOnly
                    | KFile::LocalOnly);
  connect(FileName, SIGNAL(textChanged(const QString&)),
          this, SLOT(updateCompletion()));
  _fieldCompletion = Field->completionObject();
  Field->setAutoDeleteCompletionObject( true );
}

KstVectorDialogI::~KstVectorDialogI() {
  DP = 0L;
}

KstRVectorPtr KstVectorDialogI::_getPtr(const QString &tagin) {
  KstRVectorList v = kstObjectSubList<KstVector,KstRVector>(KST::vectorList);

  if ( v.findTag(tagin) == v.end() ) {
    return 0L;
  } else {
    return *v.findTag(tagin);
  }
}

void KstVectorDialogI::updateCompletion() {
  QString current_text = Field->currentText();
  Field->clear();

  /* update filename list and fill axes combo boxes */
  KstDataSourcePtr ds = *KST::dataSourceList.findFileName(FileName->url());
  if (!ds && FileName->url() != "stdin") {
    ds = KstDataSource::loadSource(FileName->url());
    if (ds) { // FIXME we should eventually make KstDataSource::loadFieldList()
      KST::dataSourceList.append(ds);
    }
  }

  if (ds) {
    Field->insertStringList(ds->fieldList());
    _fieldCompletion->insertItems(ds->fieldList());
  }

  Field->setCurrentText(current_text);
}

void KstVectorDialogI::_fillFieldsForEdit() {
  if ( DP == 0L ) return; // shouldn't be needed
  _tagName->setText(DP->tagName());

  /* fill the fields */
  Field->clear();
  _fieldCompletion->clear();
  KstDataSourcePtr tf;
  {
    KST::dataSourceList.lock().readLock();
    KstDataSourceList::Iterator it =
      KST::dataSourceList.findFileName(DP->filename());
    if (it != KST::dataSourceList.end()) {
      tf = *it;
      Field->insertStringList(tf->fieldList());
      _fieldCompletion->insertItems(tf->fieldList());
    }
    KST::dataSourceList.lock().readUnlock();
  }
  Field->setCurrentText(DP->getField());

  /* select the proper file */
  FileName->setURL(DP->filename());

  /* fill the vector range entries */
  if (DP->countFromEOF()) {
    _kstDataRange->CountFromEnd->setChecked(true);
  } else {
    _kstDataRange->CountFromEnd->setChecked(false);
  }
  _kstDataRange->F0->setValue(DP->reqStartFrame());

  /* fill number of frames entries */
  if (DP->readToEOF()) {
    _kstDataRange->ReadToEnd->setChecked(true);
  } else {
    _kstDataRange->ReadToEnd->setChecked(false);
  }
  _kstDataRange->N->setValue(DP->reqNumFrames());

  /* fill in frames to skip box */
  _kstDataRange->Skip->setValue(DP->skip());
  _kstDataRange->DoSkip->setChecked(DP->doSkip());
  _kstDataRange->DoFilter->setChecked(DP->doAve());
  _kstDataRange->updateEnables();
}

void KstVectorDialogI::_fillFieldsForNew() {
  int n_v;
  KstRVectorList vectorList =
    kstObjectSubList<KstVector,KstRVector>(KST::vectorList);

  n_v = vectorList.count();

  if (n_v < 1) {
    Field->insertItem("INDEX");
  } else {
    Field->setCurrentText(QString::null);
  }
  QString new_label;
  new_label.sprintf("V%d-", n_v+1);
  new_label += i18n("<New_Vector>");
  _tagName->setText( new_label );

  /* set defaults with vectorDefaults */
  KST::vectorDefaults.sync();
  FileName->setURL(KST::vectorDefaults.dataSource());
  updateCompletion();
  _kstDataRange->update();
  Field->setFocus();
}

void KstVectorDialogI::update() {
  /* no longer does anything (?) */
}

bool KstVectorDialogI::new_I() {
  KstDataSourcePtr file;
  KstRVectorPtr vector;
  KstRVectorList vectorList = kstObjectSubList<KstVector,KstRVector>(KST::vectorList);
  QString tag_name = _tagName->text();

  tag_name.replace(i18n("<New_Vector>"), Field->currentText());

  KST::vectorList.lock().readLock();
  int i_c = KST::vectorList.count() + 1;
  KST::vectorList.lock().readUnlock();
  while (KST::vectorTagNameNotUnique(tag_name, false)) {
    tag_name.sprintf("V%d-", i_c);
    tag_name += Field->currentText();
    i_c++;
  }
  vectorList.clear();

  /* if there is not an active KstFile, create one */
  {
    KST::dataSourceList.lock().writeLock();
    KstDataSourceList::Iterator it = KST::dataSourceList.findFileName(FileName->url());

    if (it == KST::dataSourceList.end()) {
      file = KstDataSource::loadSource(FileName->url());
      if (!file || !file->isValid()) {
        KST::dataSourceList.lock().writeUnlock();
        KMessageBox::sorry(0L, i18n("The file could not be loaded."));
        return false;
      }
      if (file->frameCount() < 1) {
        KST::dataSourceList.lock().writeUnlock();
        KMessageBox::sorry(0L, i18n("The file does not contain data."));
        return false;
      }
      KST::dataSourceList.append(file);
    } else {
      file = *it;
    }
    KST::dataSourceList.lock().writeUnlock();
  }
  if (!file->isValidField(Field->currentText())) {
    KMessageBox::sorry(0L, i18n("The requested field is not defined for the requested file."));
    return false;
  }

  /* create the vector */
  vector = new KstRVector(
    file, Field->currentText(),
    tag_name,
    (_kstDataRange->CountFromEnd->isChecked() ? -1 : _kstDataRange->F0->value()),
    (_kstDataRange->ReadToEnd->isChecked() ? -1 : _kstDataRange->N->value()),
    _kstDataRange->Skip->value(),
    _kstDataRange->DoSkip->isChecked(),
    _kstDataRange->DoFilter->isChecked());

  KST::addVectorToList(KstVectorPtr(vector));

  emit vectorCreated(KstVectorPtr(vector));
  vector = 0L;
  emit modified();

  return true;
}

bool KstVectorDialogI::edit_I() {
  KstDataSourcePtr file;

  KstRVectorList vectorList = kstObjectSubList<KstVector,KstRVector>(KST::vectorList);

  /* verify that the vector name is unique */
  if (_tagName->text() != DP->tagName()) {
    if (KST::vectorTagNameNotUnique(_tagName->text())) {
      return false;
    }
  }

  /* if there is not an active KstFile, create one */
  {
    KST::dataSourceList.lock().writeLock();
    KstDataSourceList::Iterator it =
      KST::dataSourceList.findFileName(FileName->url());

    if (it == KST::dataSourceList.end()) {
      file = KstDataSource::loadSource(FileName->url());
      if (!file || !file->isValid()) {
        KST::dataSourceList.lock().writeUnlock();
        KMessageBox::sorry(0L, i18n("The file could not be opened."));
        return false;
      }
      if (file->frameCount() < 1) {
        KST::dataSourceList.lock().writeUnlock();
        KMessageBox::sorry(0L, i18n("The file does not contain data."));
        return false;
      }
      KST::dataSourceList.append(file);
    } else {
      file = *it;
    }
    KST::dataSourceList.lock().writeUnlock();
  }
  if (!file->isValidField(Field->currentText())) {
    KMessageBox::sorry(0L, i18n("The requested field is not defined for "
                                "the requested file\n"));
    return false;
  }

  /* change the vector */
  DP->change(file, Field->currentText(),
             _tagName->text(),
             (_kstDataRange->CountFromEnd->isChecked() ?
              -1 : _kstDataRange->F0->value()),
             (_kstDataRange->ReadToEnd->isChecked() ?
              -1 : _kstDataRange->N->value()),
             _kstDataRange->Skip->value(),
             _kstDataRange->DoSkip->isChecked(),
             _kstDataRange->DoFilter->isChecked());

  vectorList.clear();
  emit modified();
  return true;
}

#include "kstvectordialog_i.moc"
// vim: sw=2 ts=2 et
