/***************************************************************************
                       kstplotdialog_i.h  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2000-2002 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KSTPLOTEDITI_H
#define KSTPLOTEDITI_H


#include <kcombobox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qspinbox.h>

#include "kst2dplot.h"
#include "kstbasecurve.h"
#include "kstdoc.h"
#include "plotdialog.h"

class KstLabel;

#define LABELS_TAB 3
#define LIMITS_TAB 1

class KstPlotDialogI : public KstPlotDialog {
    Q_OBJECT
public:
    KstPlotDialogI(KstDoc *doc, QWidget* parent = 0, const char* name = 0,
                   bool modal = FALSE, WFlags fl = 0);
    virtual ~KstPlotDialogI();

public slots:
  /** Update info in the plot dialog */
  void updateWindow();
  void update(int new_index = -1);
  void newTab();

  /** Calls update(), then shows/raises the dialog */
  void show_I(const QString& strWindow, const QString& strPlot);
  void show_I();
  void new_I();
  void edit_I();
  void delete_I();

  /** update sample labels */
  void updateSampNumLabel();
  void updateSampTopLabel();
  void updateSampXLabel();
  void updateSampYLabel();
  void updateLabels();
  void updateSampLegendLabel();
  void updateCurveLists();
  void updateScalarCombo();
  void updateWindowList();
  void updatePlotList();

  void setScalarDestTopLabel() {ScalarDest = TopLabelText;}
  void setScalarDestXLabel() {ScalarDest = XAxisText;}
  void setScalarDestYLabel() {ScalarDest = YAxisText;}
  void insertCurrentScalar() {ScalarDest->insert(ScalarList->currentText());}

  void applyLabels(Kst2DPlotPtr plot);
  void applyLegends(Kst2DPlotPtr plot);
  void applyLimits(Kst2DPlotPtr plot);

  void applyPlotColors(Kst2DPlotPtr plot);

  void applyAutoLabels();

  void changePosition(int ci);

  void removeDisplayedCurve();
  void addDisplayedCurve();
  void removeDisplayedCurve(QListBoxItem* pItem);
  void addDisplayedCurve(QListBoxItem* pItem);

  void updateButtons();
signals:
  void docChanged();
private:
  void fill2DPlotList( Kst2DPlotList& plots );

  KstDoc *doc;
  KstLabel *SampleLabel;
  QLineEdit *ScalarDest;
  QString _strWindow;
  QString _strPlot;
};

#endif
