/***************************************************************************
                          kfvprojectlist.cpp  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kfvprojectlist.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qframe.h>
#include <qpushbutton.h>

#include "kfmprojectlist.h"
#include "kfmproject.h"

#include "kfvproject.h"

KFVProjectList::KFVProjectList(QWidget *parent, const char *name )
	: QWidget(parent,name)
{
	projectList_ = NULL;
	currentPosition_ = -1;
	
	createWidgets();
}

KFVProjectList::~KFVProjectList(){
}


////////////////////////////////////////////////////////////
// Private methods

void KFVProjectList::createWidgets(){
	setEnabled(false);
	
	QHBoxLayout* hbl = new QHBoxLayout(this);
		hbl->setSpacing(5);
		hbl->setMargin(5);
		
		createListWidgets(hbl);

		QHBoxLayout* hblDivider = new QHBoxLayout(hbl);
			hblDivider->setSpacing(0);
			QFrame* frame = new QFrame(this);
				frame->setFrameStyle(QFrame::VLine | QFrame::Raised);
				hblDivider->addWidget(frame);
			frame = new QFrame(this);
				frame->setFrameStyle(QFrame::VLine | QFrame::Raised);
				hblDivider->addWidget(frame);
			
		vProject_ = new KFVProject(this);
			hbl->addWidget(vProject_);
}

void KFVProjectList::createListWidgets(QLayout* lParent){
	QVBoxLayout* vbl = new QVBoxLayout(lParent);
		vbl->setSpacing(5);
		vbl->setMargin(5);
		
		QLabel* lProject = new QLabel("Project", this);
			vbl->addWidget(lProject);
		
		lbNames_ = new QListBox(this);
			lbNames_->setMinimumWidth(120);
			lbNames_->setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding));
			connect(lbNames_, SIGNAL(currentChanged(QListBoxItem*)), this,
					SLOT(onLbNamesCurrentChanged(QListBoxItem*)));
			vbl->addWidget(lbNames_);
			
		createButtonWidgets(vbl);

}


void KFVProjectList::createButtonWidgets(QLayout* lParent){
	QHBoxLayout* hbl = new QHBoxLayout(lParent);
		hbl->setSpacing(5);
		
		pbNew_ = new QPushButton("New", this);
			connect(pbNew_, SIGNAL(clicked()), this, SLOT(onPbNewClicked()));
			hbl->addWidget(pbNew_);
			
		pbDelete_ = new QPushButton("Delete", this);
			pbDelete_->setEnabled(false);
			connect(pbDelete_, SIGNAL(clicked()), this, SLOT(onPbDeleteClicked()));
			hbl->addWidget(pbDelete_);	
}


void KFVProjectList::currentPosition(int position, bool prevDeleted){
	if (position != currentPosition_) {
		if (currentPosition_ >= 0) {
			if (!prevDeleted) {
				disconnect(projectList_->projectAt(currentPosition_), 0, this, 0);
			}
			pbDelete_->setEnabled(false);
			vProject_->project(NULL);
			lbNames_->setSelected(currentPosition_, false);
			lbNames_->setCurrentItem(-1);
		}
		
		currentPosition_ = position;
		
		if (currentPosition_ >= 0) {
			lbNames_->setCurrentItem(currentPosition_);
			lbNames_->setSelected(currentPosition_, true);
			vProject_->project(projectList_->projectAt(currentPosition_));
			pbDelete_->setEnabled(true);
			connect(projectList_->projectAt(currentPosition_), SIGNAL(nameChanged()), this,
					SLOT(onCurrentProjectNameChanged()));
		}
	}
}

void KFVProjectList::onProjectListCurrentProjectChanged(KFMProject* project){
	currentPosition(projectList_->projectPosition(project));
}

void KFVProjectList::onProjectListProjectAdded(KFMProject* project){
	lbNames_->insertItem(project->name(), projectList_->projectPosition(project));
}

void KFVProjectList::onProjectListProjectRemoved(KFMProject* project, int pos){
	if (project == NULL) {
		currentPosition(-1, true);
		lbNames_->clear();
	}
	else {
		if (currentPosition_ == pos) {
			currentPosition(-1, true);
		}
		lbNames_->removeItem(pos);
	}
}
	
void KFVProjectList::onProjectListContentsChanged() {
	lbNames_->clear();
	KFMProject *proj;
	for (int i = 0; (proj = projectList_->projectAt(i)); i++) {
		lbNames_->insertItem(proj->name(), i);
	}

	// Reset highlighted project
	lbNames_->setCurrentItem(projectList_->currentPosition());
}

void KFVProjectList::onCurrentProjectNameChanged(){
	lbNames_->changeItem(projectList_->currentProject()->name(),
			projectList_->currentPosition());
}
	
void KFVProjectList::onLbNamesCurrentChanged(QListBoxItem* /*item*/){
	if (projectList_ != NULL) {		
		projectList_->currentProject(projectList_->projectAt(lbNames_->currentItem()));
	}
}

void KFVProjectList::onPbNewClicked(){
	if (projectList_ != NULL) {
		KFMProject* project = new KFMProject();
		projectList_->addProject(project);
		
		/* Let the user alter the name of the project.  However, projectList_
		   may have changed due to signals emitted from addProject, so check
		   it first */
		if (projectList_ != NULL && projectList_->currentProject() == project) {
			vProject_->changeName();
		}
	}
}
	
void KFVProjectList::onPbDeleteClicked(){
	if (projectList_ != NULL) {
		projectList_->removeProject(projectList_->currentProject());	
	}
}

////////////////////////////////////////////////////////////////
// Public methods

KFMProjectList* KFVProjectList::projectList() const{
	return projectList_;
}
	
void KFVProjectList::projectList(KFMProjectList* projectList, bool prevDeleted){
	if (projectList != projectList_) {
		if (projectList_ != NULL) {
			// Do stuff to clear the projectList
			
			// Disable self
			setEnabled(false);
			
			// Stop listening to projectList signals
			if (!prevDeleted) {
				disconnect(projectList_, 0, this, 0);
			}
			
			// Empty widget contents
			currentPosition(-1, prevDeleted);
			lbNames_->clear();
		}
		
		projectList_ = projectList;
		
		if (projectList_ != NULL) {
			// Do stuff to setup the projectList

			// Update widget contents
			KFMProjectList::Iterator it = projectList_->iterator();
			for (; it.current() != NULL; ++it) {			
				lbNames_->insertItem(it.current()->name());
			}
			currentPosition(projectList_->currentPosition());
				
			// Listen to projectList signals
			connect(projectList_, SIGNAL(currentProjectChanged(KFMProject*)), this,
					SLOT(onProjectListCurrentProjectChanged(KFMProject*)));
			connect(projectList_, SIGNAL(projectAdded(KFMProject*)), this,
					SLOT(onProjectListProjectAdded(KFMProject*)));
			connect(projectList_, SIGNAL(projectRemoved(KFMProject*,int)), this,
					SLOT(onProjectListProjectRemoved(KFMProject*,int)));
			connect(projectList, SIGNAL(contentsChanged()), this,
					SLOT(onProjectListContentsChanged()));
					
			// Enable self
			setEnabled(true);
		}	
	}
}
