/* -*- c++ -*-
 *
 * submitdialog.cpp
 *
 * Copyright (C) 2004 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "submitdialog.h"
#include "submitdialog.moc"

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>

#include <klocale.h>
#include <ktextedit.h>

#include "kmldonkey.h"
#include "donkeyprotocol.h"

SubmitDialog::SubmitDialog(QWidget* parent, const char* name)
    : KDialogBase(Plain, i18n("Submit URLs"), Ok|Cancel, Cancel, parent, name)
{
    QVBoxLayout* l1 = new QVBoxLayout(plainPage());
    QGroupBox* box = new QGroupBox(plainPage());
    box->setColumnLayout(0, Qt::Vertical);
    box->layout()->setSpacing(6);
    box->layout()->setMargin(11);
    box->setTitle(i18n("Submit URLs"));
    QGridLayout* boxl = new QGridLayout(box->layout());
    boxl->setAlignment(Qt::AlignTop);

    m_edit = new KTextEdit(box);
    m_edit->setFocus();
    connect(m_edit, SIGNAL(textChanged()), this, SLOT(editChanged()));
    editChanged();

    boxl->addWidget(m_edit, 0, 0);
    l1->addWidget(box);

    resize(QSize(486, 124).expandedTo(minimumSizeHint()));
    clearWState(WState_Polished);

    connect(this, SIGNAL(finished()), this, SLOT(closeDialog()));
    connect(this, SIGNAL(okClicked()), this, SLOT(addUrl()));
}

void SubmitDialog::editChanged()
{
    enableButtonOK(! m_edit->text().isEmpty());
}

void SubmitDialog::addUrl()
{
    for (int i = 0; i < m_edit->lines(); i++) {
        QString s = m_edit->text(i).stripWhiteSpace();
        if (! s.isEmpty())
            KMLDonkey::App->donkey->submitURL(s);
    }
}

void SubmitDialog::closeDialog()
{
    delayedDestruct();
}
