/***************************************************************************
                          itemdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qfileinfo.h>
#include <qheader.h>
#include <qlayout.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include <qtooltip.h>
#include <kapp.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klistview.h>
#include <klocale.h>
#include "arrayitem.h"
#include "fitdlg.h"
#include "funitem.h"
#include "itemdlg.h"
#include "kplchecklistitem.h"
#include "kpldoc.h"
#include "splfitdlg.h"
#include "splineitem.h"
#include "utils.h"

NewItemDlg::NewItemDlg(QWidget* _parent, int* i) :
 KDialog(_parent, 0, true), ityp(i)
{
  setCaption(i18n("New item"));
  QVBoxLayout* vbox = new QVBoxLayout(this, marginHint(), spacingHint());
  vbox->addWidget(bg = new QButtonGroup(7, Qt::Vertical, this));
  QPushButton* b = new QPushButton(i18n("Frame"), bg);
  int w = b->sizeHint().width();
  b = new QPushButton(i18n("Array"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Function"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Parametric Function"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Spline"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("3D Array"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("3D Function"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Legend"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Text"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Line"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Arrow"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Arc"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Rectangle"), bg);
  w = QMAX(w, b->sizeHint().width());
  b = new QPushButton(i18n("Ellipse"), bg);
  w = QMAX(w, b->sizeHint().width());
  connect(bg, SIGNAL(clicked(int)), SLOT(slotClicked(int)));
  QHBoxLayout* hbox = new QHBoxLayout(vbox, spacingHint());
  hbox->addWidget(help = new QPushButton(i18n("&Help"), this));
  connect(help, SIGNAL(clicked()), SLOT(slotHelp()));
  hbox->addItem(new QSpacerItem(10, 10));
  hbox->addWidget(b = new QPushButton(i18n("&Cancel"), this));
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(reject()));
  resize(w + w + 4 * marginHint() + spacingHint(), 200);
}

NewItemDlg::~NewItemDlg()
{
}

void NewItemDlg::keyPressEvent(QKeyEvent* e)
{
  if ((e->state() == 0) && (e->key() == Key_F1)) {
       help->animateClick();
       e->accept();
  } else
    KDialog::keyPressEvent(e);
}

void NewItemDlg::slotClicked(int id)
{
  const int types[] = {KplItem::Frame, KplItem::Array, KplItem::Function,
                       KplItem::ParFunction, KplItem::Spline, KplItem::Array3D,
                       KplItem::Function3D, KplItem::Legend,
                       KplItem::Text, KplItem::Line, KplItem::Arrow,
                       KplItem::Arc, KplItem::Rectangle, KplItem::Ellipse};
  *ityp = types[id];
  accept();
}

void NewItemDlg::slotHelp()
{
  kapp->invokeHelp("SEC-NEWITEM");
}

ItemDlg::ItemDlg(KplDoc* model) : m(model)
{
  popupMenu = new QPopupMenu();
  popupMenu->setCheckable(true);
  popupMenu->insertItem(i18n("&Edit"), this, SLOT(slotEdit()));
  popupMenu->insertItem(i18n("&Delete"), this, SLOT(slotDelete()));
  popupMenu->insertItem(i18n("&Copy"), this, SLOT(slotCopy()));
  idActive = popupMenu->insertItem(i18n("&Active"), this,
                                   SLOT(slotToggleState()));
  Utils::setGeometry(this, "ItemDialog");
  itemList = new KListView(this);
  itemList->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  itemList->addColumn(i18n("Active"));
  itemList->addColumn(i18n("Type"));
  itemList->addColumn(i18n("Settings"));
  itemList->setRootIsDecorated(true);
  itemList->setSorting(-1);
  itemList->header()->setClickEnabled(false);
  itemList->setDragEnabled(true);
  itemList->setAcceptDrops(true);
#if KDE_VERSION_MAJOR > 2
  itemList->setSelectionModeExt(KListView::FileManager);
  connect(itemList, SIGNAL(contextMenuRequested(QListViewItem*,
    const QPoint&, int)), SLOT(slotPopup(QListViewItem*, const QPoint&)));
#else
  itemList->setSelectionModeExt(KListView::Konqueror);
  connect(itemList, SIGNAL(rightButtonClicked(QListViewItem*,
    const QPoint&, int)), SLOT(slotPopup(QListViewItem*, const QPoint&)));
#endif
  connect(itemList,
          SIGNAL(moved(QListViewItem*, QListViewItem*, QListViewItem*)),
          SLOT(slotMoved(QListViewItem*, QListViewItem*, QListViewItem*)));
  connect(itemList, SIGNAL(returnPressed(QListViewItem*)),
          SLOT(slotList(QListViewItem*)));
  connect(itemList, SIGNAL(currentChanged(QListViewItem*)),
          SLOT(slotSelectionChanged(QListViewItem*)));
  connect(itemList, SIGNAL(executed(QListViewItem*)),
          SLOT(slotExecuted(QListViewItem*)));
  QHBoxLayout* hbox = new QHBoxLayout(this, marginHint(), spacingHint());
  QVBoxLayout* vbox = new QVBoxLayout(hbox, spacingHint());
  vbox->addItem(new QSpacerItem(10, 10));
  vbox->addWidget(up = new QPushButton(this));
  up->setPixmap(BarIcon("up"));
  connect(up, SIGNAL(clicked()), SLOT(slotMoveUp()));
  vbox->addWidget(down = new QPushButton(this));
  down->setPixmap(BarIcon("down"));
  connect(down, SIGNAL(clicked()), SLOT(slotMoveDown()));
  vbox->addItem(new QSpacerItem(10, 10));
  vbox = new QVBoxLayout(hbox, spacingHint());
  vbox->addWidget(itemList);
  vbox->addWidget(appendItems = new QCheckBox(i18n("Append items"), this));
  appendItems->setChecked(m->options()->appendItems);
  vbox = new QVBoxLayout(hbox, spacingHint());
  QPushButton* b = new QPushButton(i18n("&New"), this);
  vbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotNew()));
  vbox->addWidget(edit = new QPushButton(i18n("&Edit"), this));
  connect(edit, SIGNAL(clicked()), SLOT(slotEdit()));
  vbox->addWidget(fit = new QPushButton(i18n("&Fit"), this));
  connect(fit, SIGNAL(clicked()), SLOT(slotFit()));
  vbox->addWidget(del = new QPushButton(i18n("&Delete"), this));
  connect(del, SIGNAL(clicked()), SLOT(slotDelete()));
  vbox->addWidget(copy = new QPushButton(i18n("&Copy"), this));
  connect(copy, SIGNAL(clicked()), SLOT(slotCopy()));
  vbox->addWidget(help = new QPushButton(i18n("&Help"), this));
  connect(help, SIGNAL(clicked()), SLOT(slotHelp()));
  vbox->addWidget(b = new QPushButton(i18n("C&lose"), this));
  connect(b, SIGNAL(clicked()), SLOT(hide()));
  updItemList();
}

ItemDlg::~ItemDlg()
{
  delete popupMenu;
}

void ItemDlg::updItemList()
{
  QToolTip::remove(this);
  setPlainCaption(m->URL().fileName() + " - " + i18n("Items"));
  int current = lItem.findRef((KplCheckListItem*) itemList->currentItem());
  itemList->clear();
  up->setEnabled(false);
  down->setEnabled(false);
  lItem.clear();
  int nItems = m->items()->count();
  bool funcs = false, arrays = false;
  if (nItems) {
    KplCheckListItem* _parent = 0;
    for (KplItem* item = m->items()->first(); item;
         item = m->items()->next()) {
      KplItem::ItemTypes typ = item->iType();
      bool framelike = (typ == KplItem::Frame) || (typ == KplItem::Array3D) ||
                        (typ == KplItem::Function3D);
      if (_parent)
        if (framelike)
          lItem.append(new KplCheckListItem(itemList, _parent));
        else
          lItem.append(new KplCheckListItem(_parent, lItem.getLast()));
      else
        if (item == m->items()->getFirst())
          lItem.append(new KplCheckListItem(itemList));
        else
          lItem.append(new KplCheckListItem(itemList, lItem.getLast()));
      if (framelike) {
        _parent = lItem.current();
        _parent->setOpen(true);
      }
      item->setText(lItem.current(), &arrays, &funcs);
      lItem.current()->setOn(item->active);
      connect(lItem.current(), SIGNAL(stateChanged(KplCheckListItem*, bool)),
              SLOT(slotStateChanged(KplCheckListItem*, bool)));
    }
    KplCheckListItem* itm = lItem.at(QMAX(0, QMIN(current, nItems - 1)));
    itemList->setSelected(itm, true);
    itemList->setCurrentItem(itm);
    itemList->ensureItemVisible(itm);
#if KDE_VERSION_MAJOR > 2
    slotSelectionChanged(itm);
#endif
  }
  edit->setEnabled(nItems);
  fit->setEnabled(arrays && funcs);
  copy->setEnabled(nItems);
  del->setEnabled(nItems);
  itemList->setFocus();
}

void ItemDlg::moveItem()
{
  m->moveItem(iSource, iDest);
  itemList->clearSelection();
  QListViewItem* item = lItem.at(iDest);
  itemList->setCurrentItem(item);
  itemList->setSelected(item, true);
  if (!iDest)
    slotSelectionChanged(item);
}

void ItemDlg::moveItem(int di)
{
  iSource = lItem.findRef((KplCheckListItem*) itemList->currentItem());
  iDest = iSource + di;
  moveItem();
}

void ItemDlg::keyPressEvent(QKeyEvent* e)
{
  if ((e->state() == 0) && (e->key() == Key_F1)) {
       help->animateClick();
       e->accept();
  } else
    KDialog::keyPressEvent(e);
}

void ItemDlg::slotList(QListViewItem* it)
{
  int i = lItem.findRef((KplCheckListItem*) it);
  m->items()->at(i)->editItem(this, m, i);
}

void ItemDlg::slotMoved(QListViewItem* item, QListViewItem*,
                        QListViewItem* afterNow)
{
  iSource = lItem.findRef((KplCheckListItem*) item);
  iDest = lItem.findRef((KplCheckListItem*) afterNow);
  if (iSource >= 0) {
    if (iDest <= iSource)
      iDest++;
    QTimer::singleShot(0, this, SLOT(moveItem()));
  }
}

void ItemDlg::slotNew()
{
  int ityp;
  NewItemDlg dlg(this, &ityp);
  if (dlg.exec()) {
    int it = appendItems->isChecked() ? m->items()->count() :
             lItem.findRef((KplCheckListItem*) itemList->currentItem());
    m->newItem((KplItem::ItemTypes) ityp, it);
    if ((ityp == KplItem::Array) || (ityp == KplItem::Function) ||
        (ityp == KplItem::ParFunction) || (ityp == KplItem::Spline))
      for (int i = it - 1; i >= 0; i--) {
        ityp = m->items()->at(i)->iType();
        if (ityp == KplItem::Frame)
          break;
        if ((ityp == KplItem::Array) || (ityp == KplItem::Function) ||
            (ityp == KplItem::ParFunction) || (ityp == KplItem::Spline)) {
          m->items()->at(it)->normalize(((ScaledItem*)m->items()->at(i))->fx,
                                        ((ScaledItem*)m->items()->at(i))->fy);
          break;
        }
      }
    if (!m->items()->at(it)->editItem(this, m, it)) {
      m->setModified();
      m->backupItems();
    }
  }
}

void ItemDlg::slotEdit()
{
  if (QListViewItem* it = itemList->currentItem())
    slotList(it);
}

void ItemDlg::slotFit()
{
  QList<ArrayItem> arr;
  QList<FunItem> fun;
  QList<SplineItem> spl;
  for (unsigned i = 0; i < m->items()->count(); i++) {
    if (m->items()->at(i)->iType() == KplItem::Array)
      arr.append((ArrayItem*) m->items()->at(i));
    if (m->items()->at(i)->iType() == KplItem::Function)
      fun.append((FunItem*) m->items()->at(i));
    if (m->items()->at(i)->iType() == KplItem::Spline)
      spl.append((SplineItem*) m->items()->at(i));
  }
  if ((arr.count() != (fun.count() + spl.count())) || (arr.count() != 1)) {
    arr.clear();
    fun.clear();
    spl.clear();
    for (unsigned i = 0; i < m->items()->count(); i++)
      if (itemList->isSelected(lItem.at(i))) {
        switch (m->items()->at(i)->iType()) {
          case KplItem::Array:
            arr.append((ArrayItem*) m->items()->at(i));
            break;
          case KplItem::Function:
            fun.append((FunItem*) m->items()->at(i));
            break;
          case KplItem::Spline:
            spl.append((SplineItem*) m->items()->at(i));
            break;
          default:
            itemList->setSelected(lItem.at(i), false);
        }
      }
    if ((arr.count() != (fun.count() + spl.count())) || (!arr.count()) ||
        (fun.count() && spl.count()) || (spl.count() > 1)) {
      QToolTip::add(this, i18n("Select equal number of data sets\n"
                               "and either functions or splines!"));
      itemList->setFocus();
      return;
    }
  }
  if (fun.count()) {
    emit displayMessage(i18n("Fitting function parameters..."));
    FitDlg dlg(this, m, &arr, &fun, FitDlg::ShowDlg);
    dlg.exec();
  } else {
    emit displayMessage(i18n("Fitting spline..."));
    SplFitDlg dlg(this, m, arr.first(), spl.first(), FitDlg::ShowDlg);
    dlg.exec();
  }
  updItemList();
  emit displayMessage(i18n("Ready."));
}

void ItemDlg::slotDelete()
{
  bool b = false;
  for (int i = m->items()->count() - 1; i >= 0; i--)
    if (itemList->isSelected(lItem.at(i))) {
      m->items()->remove(i);
      b = true;
    }
  if (b) {
    m->setModified();
    m->backupItems();
  }
}

void ItemDlg::slotCopy()
{
  bool b = false;
  if (appendItems->isChecked()) {
    for (unsigned i = 0; i < m->items()->count(); i++)
      if (itemList->isSelected(lItem.at(i))) {
        m->items()->append(m->items()->at(i)->copy());
        b = true;
      }
  } else
    for (int i = m->items()->count() - 1; i >= 0; i--)
      if (itemList->isSelected(lItem.at(i))) {
        m->items()->insert(i, m->items()->at(i)->copy());
        b = true;
      }
  if (b) {
    m->setModified();
    m->backupItems();
  }
}

void ItemDlg::slotHelp()
{
  kapp->invokeHelp("SEC-ITEMS");
}

void ItemDlg::slotPopup(QListViewItem* item, const QPoint& p)
{
  if (item) {
    itemList->setSelected(item, true);
    popupMenu->setItemChecked(idActive, ((KplCheckListItem*) item)->isOn());
    popupMenu->exec(p);
  }
}

void ItemDlg::slotExecuted(QListViewItem* item)
{
  ((KplCheckListItem*) item)->setOn(!((KplCheckListItem*) item)->isOn());
}

void ItemDlg::slotStateChanged(KplCheckListItem* it, bool bState)
{
  m->items()->at(lItem.findRef(it))->active = bState;
  m->setModified();
  m->backupItems(false);
}

void ItemDlg::slotToggleState()
{
  if (QListViewItem* item = itemList->currentItem())
    slotExecuted(item);
}

void ItemDlg::slotSelectionChanged(QListViewItem* it)
{
  int i = lItem.findRef((KplCheckListItem*) it);
  up->setEnabled(i > 0);
  down->setEnabled(i < ((int) m->items()->count() - 1));
}

void ItemDlg::slotMoveUp()
{
  moveItem(-1);
}

void ItemDlg::slotMoveDown()
{
  moveItem(+1);
}
