/***************************************************************************
                          basicdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BASICDLG_H
#define BASICDLG_H

#include <kdialogbase.h>
#include "kplnamespace.h"

class QComboBox;
class KColorButton;
class KplDoubleEdit;
class KplSpinBox;

/**
  * Basic settings dialog class. Provides a dialog for the
  * presettings for page size and colors.
  * @author Werner Stille
  */
class BasicDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param bs pointer to autoplot settings structure.
   */
  BasicDlg(QWidget* parent, Kpl::AutoStruct* bs);
  /** Destructor. */
  ~BasicDlg();

protected:
  Kpl::AutoStruct* b;
  QComboBox *pres, *sep, *format;
  KplSpinBox* prec;
  KplDoubleEdit *formatx, *formaty;
  KColorButton *colFrame, *colGrid, *colData;
  int lFormat;
  static const double xSize[];
  static const double ySize[];

protected slots:
  /**
   * Sets page size.
   * @param i index of selected format box item.
   */
  void slotFormatChanged(int i);
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Displays help for the basic settings dialog. */
  void slotHelp2();
};

#endif
