//#include <kapp.h>
#include <qmsgbox.h>
#include "deltabledlg.h"
#include "stringres.h"
#include "my_sql.h"
#include "helpers/qt_stl_string.h"

#include "qstring.h"
#include "qlistbox.h"
#include "qpushbutton.h"

#define Inherited CDeleteTableDlgData

CDeleteTableDlg::CDeleteTableDlg(smart_pointer<CMySql>& _sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name,true ),db_list()
{
    sql_server = _sql_server;
    setCaption(CStringRes::get_string(15));
    
    db_list.resize(0);
    if (sql_server) {
        sql_server->get_db_list("%",db_list);
        if (db_list.size()) {
            for (stringlist::iterator iter=db_list.begin();iter!=db_list.end();++iter) {
                DBList->insertItem(iter->c_str());
            }
        }
        if (DBList->count()>0) {
            DBList->setSelected(0,TRUE);
        } else {
            DelTableButton->setEnabled(FALSE);
        }
    }
}

CDeleteTableDlg::~CDeleteTableDlg()
{
}

void CDeleteTableDlg::HilightDB(int item)
{
    QString item_name;
    item_name = DBList->text(item);
    stringlist table_list;
    TableList->clear();
    TableList->repaint();
    sql_server->get_table_list("%",QT_TO_STL_STRING(item_name),table_list);
    if (table_list.empty()) {
        DelTableButton->setEnabled(FALSE);
        return;
    }
    for (stringlist::iterator iter = table_list.begin();iter!=table_list.end();++iter) {
        TableList->insertItem(iter->c_str());
    }
    TableList->setSelected(0,TRUE);
    QString db = DBList->text(item);
    if (sql_server->is_system_db(QT_TO_STL_STRING(db))) {
        DelTableButton->setEnabled(FALSE);
    } else {
        DelTableButton->setEnabled(TRUE);
    }
}

void CDeleteTableDlg::DelTable()
{
    int i;
    int item;
    QString table, db;
    QString msg;
    item = TableList->currentItem();
    if (item < 0)
        return;
    table = TableList->text(item);
    i = DBList->currentItem();
    if (i < 0)
        return;
    db = DBList->text(i);
    if (sql_server->is_system_db(QT_TO_STL_STRING(db))) {
        QMessageBox::critical(this,get_error_head(),CStringRes::get_string(12) );
        return;
    }
    msg = CStringRes::get_string(13);
    msg+=" ";
    msg+= db;
    msg+=".";
    msg+=table;
    msg+="?\n";
    msg+=CStringRes::get_string(14);
    msg+="\n";
    i = QMessageBox::warning( this, CStringRes::get_string(15),
                              msg,
                              CStringRes::get_string(16),CStringRes::get_string(17),
                              0, 1 );
    if (i == 1) {
        return;
    }
    if (!sql_server->delete_table(QT_TO_STL_STRING(db),QT_TO_STL_STRING(table))) {
        QMessageBox::critical(this,get_error_head(),CStringRes::get_string(10) );
        return;
    }
    TableList->removeItem(item);
    i = DBList->currentItem();
    HilightDB(i);
}

const char*CDeleteTableDlg::get_error_head()
{
    return CStringRes::get_string(11);
}

void CDeleteTableDlg::TableHilight(int)
{
}
