#include "PatternPair.h"

CPatternPair::CPatternPair(const char*Entry,const char*Pattern,const char*aOp,bool ano_escape)
{
    entry=Entry?Entry:"";
    pattern=Pattern?Pattern:"";
    password_entry = false;
    numeric_entry = false;
    large_text = false;
    op = aOp;
    no_escape = ano_escape;
}

CPatternPair::CPatternPair(const std::string&Entry,const std::string&Pattern,const std::string&aOp,bool ano_escape)
{
    entry=Entry;
    pattern=Pattern;
    password_entry = false;
    numeric_entry = false;
    large_text = false;
    op = aOp;
    no_escape = ano_escape;
}

CPatternPair::CPatternPair(const CPatternPair& old)
{
    copy_old(old);
}

CPatternPair&CPatternPair::operator=(const CPatternPair&old)
{
    copy_old(old);
    return *this;
}

void CPatternPair::copy_old(const CPatternPair& old)
{
    entry=old.get_entry();
    pattern=old.get_pattern();
    setIsNumeric(old.isNumeric());
    setIsPassword(old.isPassword());
    setLargeText(old.isLargeText());
    no_escape=old.get_no_escape();
    op=old.get_op();
}
