/***************************************************************************
                          engine.cpp  -  description
                             -------------------
    begin                : Thu Feb 15 2001
    copyright            : (C) 2001 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "engine.h"

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>
#include <kdatetbl.h>

#include <qtextview.h>
#include <qcursor.h>
#include <qregexp.h>

#include <stdio.h>
#include <stdlib.h>

Engine::Engine()
	: _fEnglish(false),
	  _fGerman(false),
	  _fContext(false),
	  _fSensitive(false),
	  _fSearchAnd(false),
	  _fSearchOr(false)
{
}

Engine::Engine( KConfig * pConfig )
{
	restoreStatus( pConfig );
}

void Engine::saveStatus( KConfig * pConfig )
{
  pConfig->setGroup("General");
  pConfig->writeEntry( "English", _fEnglish);
  pConfig->writeEntry( "German", _fGerman);
  pConfig->writeEntry( "Context", _fContext);
  pConfig->writeEntry( "Sensitive", _fSensitive);
  pConfig->writeEntry( "SearchAnd", _fSearchAnd);
  pConfig->writeEntry( "SearchOr", _fSearchOr);
}

void Engine::restoreStatus( KConfig * pConfig )
{
  pConfig->setGroup("General");
  _fEnglish = pConfig->readBoolEntry("English");
  _fGerman = pConfig->readBoolEntry("German");
  _fContext = pConfig->readBoolEntry("Context");
  _fSensitive = pConfig->readBoolEntry("Sensitive");
  _fSearchAnd = pConfig->readBoolEntry("SearchAnd");
  _fSearchOr = pConfig->readBoolEntry("SearchOr");
}

/*******************************************************/
/* write translation on display pView (in append mode) */
/*******************************************************/
void Engine::translate( const QString & szWord, QTextView * pView)
{
  FILE *fp;
  QString command;
  QString sline;//(1024);	
  char line[1024];

  unsigned int MaxLength=0;
  nRows = 1;

  //set clock-cursor
  KApplication::setOverrideCursor(Qt::waitCursor);

  //Befehl zusammensetzen
  command="steak -nowait";
  if (_fEnglish & _fGerman)
	command.append(" -de");
  else if (_fGerman)
	command.append(" -d");
  else if (_fEnglish)
	command.append(" -e");
  if (!_fContext)
	command.append(" -k");
  if (_fSensitive)
	command.append(" -noignor");
  if (_fSearchAnd)
	command.append(" -and");
  if (_fSearchOr)
	command.append(" -or");
  command.append(" ");

	if ( ! szWord.isEmpty() )
		command.append( szWord );

  //ausfuehren
  if ((fp = popen(command, "r")) == NULL) {
	fprintf(stderr, "popen error");
	exit(1);
  }

 while ((fgets(line, 1024, fp)) != NULL)
    {
      sline = line;	
      sline=sline.stripWhiteSpace();
      //haessliche Zeilen rausfiltern
      sline.replace( QRegExp("^\\d+\\s*)\\s*"), ""); //remove numbers at the begin of line
      
      // string match for :== 
      int i = sline.find(":==");
      if ( i > 0 )
	{
	  sline.remove(i, 4);
	  if (i >= (int) MaxLength)                        //string befor :==
	    {
	      szMaxLine=sline.left(i);
	      MaxLength = i;
	    }
	  if (sline.length()-i > MaxLength)          //string after :==
	    {
	      szMaxLine="    "+sline.right(sline.length()-i);
	      MaxLength=sline.length()-i+5;
	    }
	  sline.insert(0, "<B>");
	  sline.insert(i+2, "</B><BR> &nbsp; &nbsp; ");
	  nRows+=2;
	  pView->append(sline);
	}
      else  // :== not found
	{
	  if (!sline.contains("-", TRUE)) 
	    {
	      if (sline.length() > MaxLength) // other strings 
		{ 
		  szMaxLine=sline.right(sline.length());
		  MaxLength=sline.length();
		}
	      nRows++;
	      pView->append(sline);
	    }
	}
      if (sline.contains("--- Jetzt die Kontext", TRUE)) 
	{
	  pView->append("<BR><B><U>"+i18n("Context")+"</U></B><BR>");
	  nRows++;
	}
    } //end while loop


  if (ferror(fp))
		printf("fgets error");
  pclose(fp);
  //restore cursor
  KApplication::restoreOverrideCursor();
}

/**********************************************
 * write translation in a popup window        *
 **********************************************/
void Engine::translatePopup( const QString & szWord, QTextView * pView )
{
  int w, h, maxw, maxh;

  translate( szWord, pView );

  //compute widget-size
  QFont tFont = pView->viewport()->font();
  tFont.setWeight( QFont::Bold );
  QFontMetrics fm(tFont);
  w = fm.width(szMaxLine)+35;
  h = fm.height()*(nRows+3);

  maxw = QApplication::desktop()->width()/2;
  maxh = QApplication::desktop()->height()/3;
  if ( w > maxw ) w=maxw;
  if ( h > maxh ) h=maxh; 

  //set widget-size
  pView->resize(w,h);
}
