/*
     File: khronotimedisplay.cpp
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "khronotimedisplay.h"
#include "khronotimer.h"
#include <qpainter.h>
#include <qwidget.h>

KhronoTimeDisplay::KhronoTimeDisplay( QWidget *parent, const char *name )
    : QLCDNumber( parent, name )
{
  setNumDigits(8);
  timer=new KhronoTimer( this, "timer" );
  QObject::connect(timer, SIGNAL(tick()), this, SLOT(displayTime()));
  displayTime();
}

KhronoTimer* KhronoTimeDisplay::getTimer()
{
  return timer;
}

void KhronoTimeDisplay::displayTime()
{
  display( timer->toString() );
}

void KhronoTimeDisplay::paintEvent( QPaintEvent *e )
{
  QLCDNumber::paintEvent( e );
  QPainter p;
  p.begin( this );
  p.setPen(palette().normal().background());
  p.drawRect(1, 1, width()-2, height()-2);
  p.setPen(palette().normal().foreground());
  p.drawRect(0, 0, width(), height());
  p.end();
}
