/*
     File: khronodock.cpp
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "khronodock.h"
#include "khronodisplay.h"
#include "khronotimedisplay.h"
#include "khronotimer.h"
#include "khronostatepanel.h"
#include <qevent.h>
#include <qpainter.h>
#include <qfont.h>
#include <qstring.h>

KhronoDock::KhronoDock( QWidget *parent, const char *name, KhronoDisplay* app )
    : KDockWindow( parent, name )
{
  mainChrono = app;
  startState=TRUE;
  pauseState=FALSE;
  laps_=0;
  if( mainChrono!=0 ) {
    QObject::connect(mainChrono->getTimeDisplay()->getTimer(), SIGNAL(tick()),
    		     this, SLOT(displayTime()));
    QObject::connect(mainChrono->getTimeDisplay()->getTimer(), SIGNAL(started(bool)),
    		     this, SLOT(setStart(bool)));
    QObject::connect(mainChrono->getTimeDisplay()->getTimer(), SIGNAL(paused(bool)),
    		     this, SLOT(setPause(bool)));
    QObject::connect(mainChrono->getTimeDisplay()->getTimer(), SIGNAL(modeSwitched(int)),
    		     this, SLOT(setMode(int)));
    QObject::connect(mainChrono, SIGNAL(lapped()),
    		     this, SLOT(lap()));
    QObject::connect(mainChrono, SIGNAL(themeChanged(QColorGroup*)),
    		     this, SLOT(setTheme(QColorGroup*)));
    setPalette(mainChrono->getTimeDisplay()->palette());
  }
  timeStr=new QString("00:00");
  displayTime();
}

// *** Evenements *** //

void KhronoDock::mousePressEvent( QMouseEvent *evt )
{
  switch(evt->button()) {
  case LeftButton: {
    if( mainChrono!=0 )
      if( evt->state() & ControlButton )
        mainChrono->lap();
      else
        if( mainChrono->getTimeDisplay()->getTimer()->getMode()!=TIME )
          mainChrono->getTimeDisplay()->getTimer()->startStop();
    break;
  }
  case RightButton: {
    if( mainChrono!=0 )
      mainChrono->getTimeDisplay()->getTimer()->switchMode();
    break;
  }
  case MidButton: {
    if( mainChrono!=0 )
      mainChrono->getTimeDisplay()->getTimer()->reset();
    break;
  }
  default: break;
  }
}

void KhronoDock::paintEvent( QPaintEvent * )
{
  QPainter p;
  p.begin( this );
  p.setPen( foregroundColor() );
  p.setBrush( foregroundColor() );
  //p.scale(0.75, 1.);
  QFont font=p.font();
  //font.setWeight(QFont::Black);
  font.setPointSize(8);
  QFontMetrics fm(font);
  int h=fm.height();
  int w=fm.width((const char*)(*timeStr));
  p.setFont(font);
  if( mainChrono!=0 ) {
    switch( mainChrono->getTimeDisplay()->getTimer()->getMode() ) {
    case TIME: {
      p.drawText( 0, 8, "T" );
      break;
    }
    case CHRONO: {
      p.drawText( 5, 8, "K" );
      break;
    }
    case COUNTDOWN: {
      p.drawText( 10, 8, "C" );
      break;
    }
    }
    if( pauseState==TRUE ) {
      int size=6;
      p.drawRect( width()-size, 1, size/3, size );
      p.drawRect( width()-size+2*size/3-1, 1, size/3, size );
    } else
    if( startState==TRUE ) {
      QPointArray play;
      int size=6;
      play.setPoints( 3, width()-size,       1+0,
                         width()-1,          1+size/2,
		         width()-size,       1+size );
      p.drawPolygon( play );
    }
  }
  p.drawText( (width()-w)/2, (height()+h)/2, (const char*)(*timeStr) );
  int size=4;
  for(int i=0; i<laps_; i++) {
    p.drawEllipse(i*(size+1)+1, height()-size-1, size, size);
  }
  p.end();
}

// *** Public slots *** //

void KhronoDock::displayTime()
{
  delete timeStr;
  QString timerStr=mainChrono->getTimeDisplay()->getTimer()->toString();
  timeStr=new QString(timerStr.right(5));
  repaint();
}

void KhronoDock::setStart(bool started)
{
  if( started==startState ) return;
  startState=started;
  if( started==TRUE ) laps_=0;
  repaint();
}

void KhronoDock::setPause(bool paused)
{
  if( paused==pauseState ) return;
  pauseState=paused;
  repaint();
}

void KhronoDock::setMode(int)
{
  laps_=0;
  repaint();
}

void KhronoDock::lap()
{
  if( laps_<MAXLAPS ) laps_++;
  repaint();
}

void KhronoDock::setTheme(QColorGroup* colors)
{
  setPalette(QPalette(*colors, *colors, *colors));
}
