/***************************************************************************
                          edittextdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <klocale.h>
#include "edittextdlg.h"

Preview::Preview(QWidget* parent) : QWidget(parent), str(" ")
{
  QWidget::setBackgroundColor(white);
}

Preview::~Preview()
{
}

void Preview::setText(const QString& s)
{
  str = s;
  update();
}

void Preview::paintEvent(QPaintEvent*)
{
  plInit(this, 0, 0);
  setRelSize(2.0);
  text(str, 10, 20, 1);
  end();
}

EditTextDlg::EditTextDlg(QWidget* parent, QLineEdit* e) :
 QDialog(parent, 0, true), sfont("#NN"), ed(e)
{
  setCaption(i18n("Edit text"));
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  vbox->addWidget(editPreview = new Preview(this));
  editPreview->setMinimumHeight(40);
  editPreview->setText(ed->text());
  QGridLayout* grid = new QGridLayout(vbox, 2, 2);
  grid->addWidget(text = new QLineEdit(ed->text(), this), 0, 0);
  text->setCursorPosition(strlen(ed->text()));
  connect(text, SIGNAL(textChanged(const QString&)),
          editPreview, SLOT(setText(const QString&)));
  QHBoxLayout* hbox = new QHBoxLayout(6);
  grid->addLayout(hbox, 0, 1);
  QPushButton* b = new QPushButton("<", this);
  hbox->addWidget(b);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotCat()));
  hbox->addWidget(font = new QLineEdit(sfont, this));
  font->setFixedWidth(60);
  grid->addWidget(bg1 = new QButtonGroup(6, Qt::Vertical, i18n("Font"), this),
                  1, 0);
  QRadioButton* r = new QRadioButton("Helvetica", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r->setChecked(true);
  r = new QRadioButton("Helvetica Bold", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r = new QRadioButton("Helvetica Italic", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r = new QRadioButton("Helvetica Bold Italic", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r = new QRadioButton("Symbol", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r = new QRadioButton("ZapfDingbats", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  grid->addLayout(vbox = new QVBoxLayout(6), 1, 1);
  vbox->addWidget(bg2 = new QButtonGroup(3, Qt::Vertical,
                                          i18n("Position"), this));
  r = new QRadioButton(i18n("Up"), bg2);
  connect(r, SIGNAL(clicked()), SLOT(slotPos()));
  r = new QRadioButton(i18n("Normal"), bg2);
  connect(r, SIGNAL(clicked()), SLOT(slotPos()));
  r->setChecked(true);
  r = new QRadioButton(i18n("Down"), bg2);
  connect(r, SIGNAL(clicked()), SLOT(slotPos()));
  vbox->addWidget(b = new QPushButton(i18n("OK"), this));
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(slotOK()));
  vbox->addWidget(b = new QPushButton(i18n("Cancel"), this));
  connect(b, SIGNAL(clicked()), SLOT(reject()));
}

EditTextDlg::~EditTextDlg()
{
}

void EditTextDlg::slotCat()
{
  text->insert(font->text());
}

void EditTextDlg::slotFont()
{
  int i = -1;
  QRadioButton* rb;
  do
    rb = (QRadioButton*) bg1->find(++i);
  while (!rb->isChecked());
  const char fs[] = "HBOISZ";
  sfont[1] = fs[i];
  font->setText(sfont);
}

void EditTextDlg::slotPos()
{
  int i = -1;
  QRadioButton* rb;
  do
    rb = (QRadioButton*) bg2->find(++i);
  while (!rb->isChecked());
  const char ps[] = "UND";
  sfont[2] = ps[i];
  font->setText(sfont);
}

void EditTextDlg::slotOK()
{
  ed->setText(text->text());
  accept();
}
