//**************************************************************************
//                        qextmdienums.h  -  description
//                           -------------------
//  begin                : Fri Nov 24 2000
//  copyright            : (C) 2000 by Bjrn Sahlstrm
//  email                : bjorn@kbear.org
//**************************************************************************/

//**************************************************************************
//                                                                         *
//   This program is free software; you can redistribute it and/or modify  *
//   it under the terms of the GNU General Public License as published by  *
//  the Free Software Foundation; either version 2 of the License, or     *
//  (at your option) any later version.                                   *
//                                                                        *
//*************************************************************************/
#ifndef QEXTMDI_ENUM
#define QEXTMDI_ENUM

namespace QextMdi {

/**
* During @ref QextMdiMainFrm::addWindow the enum AddWindowFlags is used to determine how the view is initialy being added to the MDI system
*/
typedef enum {
      /**
      * standard is: show normal, attached, visible, document view (not toolview)
      */
      StandardAdd = 0,
      /**
      * add a maximized view
      */
      Maximize    = 1,
      /**
      * add a minimized view
      */
      Minimize    = 2,
      /**
      * add a view that is not visible for the moment but under MDI control
      */
      Hide        = 4,
      /**
      * add a view that appears toplevel
      */
      Detach      = 8,
      /**
      * add the view as tool view. That means it is stay-on-top and toplevel
      */
      ToolWindow  = 16
   } AddWindowFlags;

typedef enum {
      KDE1Look  = 0,
      KDE2Look  = 1
   } QextMdiFrameDecor;
}; //namespace

#endif
