/* demo1.cpp */

#include <stdio.h>
#include <unistd.h>
#include <dcopclient.h>
#include <kprocess.h>
#include <kapp.h>
#include <kpl_stub.h>
#if KDE_VERSION_MAJOR > 2
#include "/opt/kde3/share/apps/kpl/kpl_stub.cpp"
#else
#include "/opt/kde2/share/apps/kpl/kpl_stub.cpp"
#endif

int main()
{
  DCOPClient client;
  fprintf(stderr, "Attaching...\n");
  client.attach();
  if (!client.isApplicationRegistered("kpl")) {
    fprintf(stderr, "Kpl is not running, let`s start it.\n");
    KProcess proc;
    proc << "kpl";
    if (!proc.start(KProcess::DontCare)) {
      fprintf(stderr, "Kpl cannot be started.\n");
      return 1;
    }
    int i = 0;
    do {
      sleep(1);
      if (++i > 10) {
        fprintf(stderr, "Kpl is not registered as a DCOP client.\n");
        return 2;
      }
    } while (!client.isApplicationRegistered("kpl"));
  }
  fprintf(stderr, "Creating interface...\n");
  KplApp_stub iface(&client, "kpl", "KplIface");
  fprintf(stderr, "Autoplot settings\n");
  iface.setAutoplot(4.0, 15.0, 3.0, 10.0, 2, "x", "y", "",
                    1, 0, 1, 2, 0, 0, 0, 1, 1, 0);
  fprintf(stderr, "Setting Autoplot on\n");
  iface.setAutoplotOption(1);
  fprintf(stderr, "Open data file... ");
  fprintf(stderr, "%s\n", iface.openData("/opt/kde2/share/apps/kpl/demo1.dat") ?
          "true" : "false");
  sleep(3);
  fprintf(stderr, "Open plot file... ");
  fprintf(stderr, "%s\n", iface.openPlot("/opt/kde2/share/apps/kpl/demo5.plo") ?
          "true" : "false");
  sleep(3);
  fprintf(stderr, "Deleting items... ");
  fprintf(stderr, "%s ", iface.deleteItem(8) ? "true" : "false");
  fprintf(stderr, "%s ", iface.deleteItem(4) ? "true" : "false");
  fprintf(stderr, "%s ", iface.deleteItem(6) ? "true" : "false");
  fprintf(stderr, "%s ", iface.deleteItem(3) ? "true" : "false");
  fprintf(stderr, "%s ", iface.deleteItem(4) ? "true" : "false");
  fprintf(stderr, "%s ", iface.deleteItem(2) ? "true" : "false");
  sleep(3);
  fprintf(stderr, "New plot\n");
  iface.newPlot();
  fprintf(stderr, "New frame item\n");
  iface.newFrameItem(4.0, 15.0, 3.0, 10.0, 0.0, 12.5664, -2.0, 2.0, 0, 0,
                     2, -1, "0", "0", 3.14159, 1.0, 2, 2, 2, 0, 0, "x", "y",
                     "Fourier synthesis", 1.0, 1);
  fprintf(stderr, "Setting Autoplot off\n");
  iface.setAutoplotOption(0);
  fprintf(stderr, "New function item\n");
  iface.newFunItem("/opt/kde2/share/apps/kpl/fkt.so", "foursynth",
                   0.0, 12.566, 0.01, 1, "ff", 1.0, 1.0, 1);
  fprintf(stderr, "Setting parameter... ");
  fprintf(stderr, "%s\n", iface.setPar(1, 3, 0.0, 1) ? "true" : "false");
  fprintf(stderr, "Performing plot\n");
  iface.doPlot();
  sleep(1);
  fprintf(stderr, "Setting Autoplot on\n");
  iface.setAutoplotOption(1);
  fprintf(stderr, "Changing parameters...  ");
  for (int i = 1; i < 11; i++)
    fprintf(stderr, "%s ", iface.setPar(1, 3, i * 0.1, 1) ? "true" : "false");
  sleep(2);
  fprintf(stderr, "%s ", iface.setPar(1, 7, -0.11111111, 1) ? "true" : "false");
  fprintf(stderr, "%s ", iface.setPar(1, 11, 0.04, 1) ? "true" : "false");
  fprintf(stderr, "%s ", iface.setPar(1, 15, -0.0204082, 1) ? "true" : "false");
  fprintf(stderr, "%s\n", iface.setPar(1, 19, 0.0123457, 1) ? "true" : "false");
  sleep(3);
  fprintf(stderr, "New plot\n");
  iface.newPlot();
  fprintf(stderr, "New frame item\n");
  iface.newFrameItem(4.0, 10.0, 3.0, 10.0, -1.0, 1.0, -1.0, 1.0, 0, 0, 1, 1,
                     "0", "0", 0.5, 0.5, 5, 5, 2, 0, 0, "x", "y",
                     "Parametric function", 1.5, 1);
  fprintf(stderr, "New parametric function item\n");
  iface.newParFunItem("/opt/kde2/share/apps/kpl/fkt.so", "foursynth",
                      "/opt/kde2/share/apps/kpl/fkt.so", "foursynth",
                      0.0, 6.28318, 0.0, 1, "ff", 1.0, 1.0, 1);
  fprintf(stderr, "Setting Autoplot off\n");
  iface.setAutoplotOption(0);
  for (int i = 0; i < 10; i++) {
    fprintf(stderr, "Changing parameters...  ");
    fprintf(stderr, "%s ", iface.setPar(1, 2, i * 0.1, 1) ? "true" : "false");
    fprintf(stderr, "%s\n", iface.setPar(1, 7, i * 0.1, 0) ? "true" : "false");
    fprintf(stderr, "Performing plot\n");
    iface.doPlot();
  }
  sleep(3);
  fprintf(stderr, "New plot\n");
  iface.newPlot();
  fprintf(stderr, "New autoframe item\n");
  iface.newAutoFrameItem();
  fprintf(stderr, "New array item\n");
  iface.newArrayItem("/opt/kde2/share/apps/kpl/demo7.dat",
                     0, 1, 2, 0, 51, 1, 0, "0", 1.0, 1.0, 1);
  fprintf(stderr, "New array item\n");
  iface.newArrayItem("/opt/kde2/share/apps/kpl/demo7.dat",
                     0, 3, 4, 0, 51, 1, 0, "0", 1.0, 1.0, 1);
  fprintf(stderr, "Autoscaling...  ");
  fprintf(stderr, "%s\n", iface.autoScaleFrame(0, 1) ? "true" : "false");
  fprintf(stderr, "New function item\n");
  iface.newFunItem("/opt/kde2/share/apps/kpl/fcompl.so",
                   "epsilon_1__FdPCd", 2.0, 7.0, 0.0, 1, "0",
                   1.0, 1.0, 1);
  fprintf(stderr, "Changing parameters... ");
  fprintf(stderr, "%s ", iface.setPar(3, 0, 3.5, 1) ? "true" : "false");
  fprintf(stderr, "%s ", iface.setPar(3, 1, 8.5, 1) ? "true" : "false");
  fprintf(stderr, "%s ", iface.setPar(3, 2, 7500.0, 1) ? "true" : "false");
  fprintf(stderr, "%s ", iface.setPar(3, 3, 1.0, 1) ? "true" : "false");
  fprintf(stderr, "%s\n", iface.setPar(3, 4, 150000.0, 1) ? "true" : "false");
  fprintf(stderr, "New function item\n");
  iface.newFunItem("/opt/kde2/share/apps/kpl/fcompl.so",
                   "epsilon_2__FdPCd", 2.0, 7.0, 0.0, 1, "ff",
                   1.0, 1.0, 1);
  fprintf(stderr, "Changing parameters... ");
  fprintf(stderr, "%s ", iface.setPar(4, 0, 3.5, 1) ? "true" : "false");
  fprintf(stderr, "%s ", iface.setPar(4, 1, 8.5, 1) ? "true" : "false");
  fprintf(stderr, "%s ", iface.setPar(4, 2, 7500.0, 1) ? "true" : "false");
  fprintf(stderr, "%s ", iface.setPar(4, 3, 1.0, 1) ? "true" : "false");
  fprintf(stderr, "%s\n", iface.setPar(4, 4, 150000.0, 1) ? "true" : "false");
  fprintf(stderr, "Performing plot\n");
  iface.doPlot();
  fprintf(stderr,  "Setting Autoplot on\n");
  iface.setAutoplotOption(1);
  fprintf(stderr, "Enabling fit parameters... ");
  for (int i = 0; i < 20; i++)
    fprintf(stderr, "%s ", iface.enableFitPar(i, (i < 5) ? 1 : 0) ?
            "true" : "false");
  fprintf(stderr, "\nAdding fit items... ");
  fprintf(stderr, "%s ", iface.addFitItems(1, 1, 3, 1, "", "") ? "true" : "false");
  fprintf(stderr, "%s\n", iface.addFitItems(0, 2, 4, 1, "", "") ? "true" : "false");
  sleep(3);
  fprintf(stderr, "Performing fit... ");
  fprintf(stderr, "%s\n", iface.fit(1, 0, 0) ? "true" : "false");
  fprintf(stderr, "chi-square = %g\n", iface.chiSquare());
  sleep(3);
  fprintf(stderr, "New plot\n");
  iface.newPlot();
  fprintf(stderr, "New legend item\n");
  iface.newLegendItem(-17, "0", 3.2, 7.5, "#BNThe End", "cc6600", 0.0, 0.0,
                      5.0, 1);
  return 0;
}
